/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.internal.client.RenderTypes;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.sprite.AtlasSpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class ModRenderHelper {
    public static final float ONE_PIXEL = 0.0625f;
    public static final int GUI_TOPMOST_Z = 900;
    public static final int GUI_ITEM_Z = 600;
    public static final NonNullSupplier<Font> DEFAULT_FONT_RENDERER = () -> Minecraft.m_91087_().f_91062_;

    public static long getLastRenderTime() {
        return ZeroCore.getProxy().getLastRenderTime();
    }

    public static ModelManager getModelManager() {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110881_();
    }

    public static UnbakedModel getModel(ResourceLocation location) {
        return Minecraft.m_91087_().m_91304_().getModelBakery().m_119341_(location);
    }

    public static BakedModel getModel(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state);
    }

    public static BakedModel getModel(ModelResourceLocation modelLocation) {
        return ModRenderHelper.getModelManager().m_119422_(modelLocation);
    }

    public static BakedModel getMissingModel() {
        return ModRenderHelper.getModelManager().m_119409_();
    }

    @Nullable
    public static BakedModel getMissingModel(Map<ResourceLocation, BakedModel> modelRegistry) {
        return modelRegistry.get(ModelBakery.f_119230_);
    }

    public static void bindTexture(ResourceLocation textureLocation) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
    }

    public static void bindTexture(ISprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.getTextureMap().getTextureLocation());
    }

    public static void bindBlocksTexture() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
    }

    public static TextureAtlasSprite getTextureSprite(ResourceLocation location) {
        return ModRenderHelper.getTextureSprite(InventoryMenu.f_39692_, location);
    }

    public static TextureAtlasSprite getTextureSprite(ResourceLocation atlasName, ResourceLocation spriteName) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(atlasName).apply(spriteName);
    }

    public static TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(Objects.requireNonNull(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture()));
    }

    public static TextureAtlasSprite getFluidStillSprite(FluidStack stack) {
        return ModRenderHelper.getTextureSprite(Objects.requireNonNull(IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getStillTexture(stack)));
    }

    public static TextureAtlasSprite getFluidFlowingSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(Objects.requireNonNull(IClientFluidTypeExtensions.of((Fluid)fluid).getFlowingTexture()));
    }

    public static TextureAtlasSprite getFluidFlowingSprite(FluidStack stack) {
        return ModRenderHelper.getTextureSprite(Objects.requireNonNull(IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getFlowingTexture(stack)));
    }

    public static TextureAtlasSprite getMissingTexture(ResourceLocation atlasName) {
        return ModRenderHelper.getTextureSprite(atlasName, MissingTextureAtlasSprite.m_118071_());
    }

    public static TextureAtlasSprite getMissingTexture() {
        return ModRenderHelper.getTextureSprite(MissingTextureAtlasSprite.m_118071_());
    }

    @Nullable
    public static TextureAtlasSprite getFluidOverlaySprite(Fluid fluid) {
        ResourceLocation rl = IClientFluidTypeExtensions.of((Fluid)fluid).getOverlayTexture();
        return null != rl ? ModRenderHelper.getTextureSprite(rl) : null;
    }

    @Nullable
    public static TextureAtlasSprite getFluidOverlaySprite(FluidStack stack) {
        ResourceLocation rl = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getOverlayTexture(stack);
        return null != rl ? ModRenderHelper.getTextureSprite(rl) : null;
    }

    public static int getFluidTint(Fluid fluid) {
        return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
    }

    public static int getFluidTint(FluidStack stack) {
        return IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getTintColor(stack);
    }

    public static Colour getFluidTintColour(Fluid fluid) {
        return Colour.fromARGB(ModRenderHelper.getFluidTint(fluid));
    }

    public static Colour getFluidTintColour(FluidStack stack) {
        return Colour.fromARGB(ModRenderHelper.getFluidTint(stack));
    }

    public static ISprite getStillFluidSprite(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(fluid), null);
    }

    public static ISprite getStillFluidSprite(FluidStack stack) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(stack), null);
    }

    public static ISprite getStillFluidSpriteWithOverlay(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(fluid), ModRenderHelper.getFluidOverlaySprite(fluid));
    }

    public static ISprite getStillFluidSpriteWithOverlay(FluidStack stack) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(stack), ModRenderHelper.getFluidOverlaySprite(stack));
    }

    public static ISprite getFlowingFluidSprite(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(fluid), null);
    }

    public static ISprite getFlowingFluidSprite(FluidStack stack) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(stack), null);
    }

    public static ISprite getFlowingFluidSpriteWithOverlay(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(fluid), ModRenderHelper.getFluidOverlaySprite(fluid));
    }

    public static ISprite getFlowingFluidSpriteWithOverlay(FluidStack stack) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(stack), ModRenderHelper.getFluidOverlaySprite(stack));
    }

    private static ISprite buildSprite(TextureAtlasSprite main, @Nullable TextureAtlasSprite overlay) {
        ISprite s = AtlasSpriteTextureMap.from(main).sprite(main);
        if (null != overlay) {
            return s.copyWith(AtlasSpriteTextureMap.from(overlay).sprite(overlay));
        }
        return s;
    }

    public static List<FormattedText> splitLines(Font font, String line, int maxLineWidth) {
        return ModRenderHelper.splitLines(font, line, maxLineWidth, Style.f_131099_);
    }

    public static List<FormattedText> splitLines(Font font, String line, int maxLineWidth, Style lineStyle) {
        return font.m_92865_().m_92432_(line, maxLineWidth, lineStyle);
    }

    public static List<FormattedText> splitLines(Font font, FormattedText line, int maxLineWidth) {
        return ModRenderHelper.splitLines(font, line, maxLineWidth, Style.f_131099_);
    }

    public static List<FormattedText> splitLines(Font font, FormattedText line, int maxLineWidth, Style lineStyle) {
        return font.m_92865_().m_92414_(line, maxLineWidth, lineStyle);
    }

    public static int addBlockLight(int combinedLight, int blockLight) {
        return combinedLight & 0xFFFF0000 | Math.max(blockLight << 4, combinedLight & 0xFFFF);
    }

    public static void renderBlockFace(VertexConsumer renderer, Matrix4f matrix, Direction face, float x1, float y1, float z1, float x2, float y2, float z2, float minU, float maxU, float minV, float maxV, int color, int brightness) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int light1 = brightness & 0xFFFF;
        int light2 = brightness >> 16 & 0xFFFF;
        switch (face) {
            case DOWN: {
                renderer.m_252986_(matrix, x1, y1, z2).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y1, z1).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z1).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z2).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_7120_(light1, light2).m_5752_();
                break;
            }
            case UP: {
                renderer.m_252986_(matrix, x1, y2, z1).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z2).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z2).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z1).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_7120_(light1, light2).m_5752_();
                break;
            }
            case NORTH: {
                renderer.m_252986_(matrix, x1, y1, z1).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z1).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z1).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z1).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_7120_(light1, light2).m_5752_();
                break;
            }
            case SOUTH: {
                renderer.m_252986_(matrix, x2, y1, z2).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z2).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z2).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y1, z2).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_7120_(light1, light2).m_5752_();
                break;
            }
            case WEST: {
                renderer.m_252986_(matrix, x1, y1, z2).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z2).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z1).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y1, z1).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_7120_(light1, light2).m_5752_();
                break;
            }
            case EAST: {
                renderer.m_252986_(matrix, x2, y1, z1).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z1).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z2).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z2).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_7120_(light1, light2).m_5752_();
            }
        }
    }

    public static void renderQuads(PoseStack matrix, VertexConsumer builder, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        PoseStack.Pose entry = matrix.m_85850_();
        for (BakedQuad quad : quads) {
            builder.putBulkData(entry, quad, 1.0f, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderQuads(PoseStack matrix, VertexConsumer builder, List<BakedQuad> quads, int combinedLight, int combinedOverlay, IntFunction<Colour> quadTintGetter) {
        PoseStack.Pose entry = matrix.m_85850_();
        for (BakedQuad quad : quads) {
            float alpha;
            float blue;
            float green;
            float red;
            if (quad.m_111304_()) {
                Colour tint = quadTintGetter.apply(quad.m_111305_());
                red = tint.R;
                green = tint.G;
                blue = tint.B;
                alpha = tint.A;
            } else {
                alpha = 1.0f;
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            builder.putBulkData(entry, quad, red, green, blue, alpha, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderModel(BakedModel model, ModelData data, PoseStack matrix, VertexConsumer builder, int combinedLight, int combinedOverlay, @Nullable RenderType renderType) {
        for (Direction direction : CodeHelper.DIRECTIONS) {
            ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, direction, CodeHelper.fakeRandom(), data, renderType), combinedLight, combinedOverlay);
        }
        ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, null, CodeHelper.fakeRandom(), data, renderType), combinedLight, combinedOverlay);
    }

    public static void renderModel(BakedModel model, ModelData data, PoseStack matrix, VertexConsumer builder, int combinedLight, int combinedOverlay, IntFunction<Colour> quadTintGetter, @Nullable RenderType renderType) {
        for (Direction direction : CodeHelper.DIRECTIONS) {
            ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, direction, CodeHelper.fakeRandom(), data, renderType), combinedLight, combinedOverlay, quadTintGetter);
        }
        ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, null, CodeHelper.fakeRandom(), data, renderType), combinedLight, combinedOverlay, quadTintGetter);
    }

    public static Vector3d[] getQuadVerticesFor(Direction face, float width, float height, float depth) {
        return ModRenderHelper.getQuadVerticesFor(face, width, height, depth, Vector3d.ZERO);
    }

    public static Vector3d[] getQuadVerticesFor(Direction face, float width, float height, float depth, Vector3d offset) {
        Vector3d bottomToTop;
        Vector3d leftToRight;
        Vector3d nearToFar = switch (face) {
            case Direction.NORTH -> {
                leftToRight = Vector3d.XN;
                bottomToTop = Vector3d.YP;
                yield Vector3d.ZN;
            }
            case Direction.SOUTH -> {
                leftToRight = Vector3d.XP;
                bottomToTop = Vector3d.YP;
                yield Vector3d.ZP;
            }
            case Direction.EAST -> {
                leftToRight = Vector3d.ZN;
                bottomToTop = Vector3d.YP;
                yield Vector3d.XP;
            }
            default -> {
                leftToRight = Vector3d.ZP;
                bottomToTop = Vector3d.YP;
                yield Vector3d.XN;
            }
            case Direction.UP -> {
                leftToRight = Vector3d.XN;
                bottomToTop = Vector3d.ZP;
                yield Vector3d.YP;
            }
            case Direction.DOWN -> {
                leftToRight = Vector3d.XP;
                bottomToTop = Vector3d.ZP;
                yield Vector3d.YN;
            }
        };
        leftToRight = leftToRight.multiply((double)width * 0.5);
        bottomToTop = bottomToTop.multiply((double)height * 0.5);
        nearToFar = nearToFar.multiply((double)depth * 0.5);
        Vector3d[] vertices = new Vector3d[]{Vector3d.HALF.subtract(leftToRight).subtract(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.add(leftToRight).subtract(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.add(leftToRight).add(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.subtract(leftToRight).add(bottomToTop).add(nearToFar).add(offset)};
        return vertices;
    }

    public static void paintVoxelShape(VoxelShape shape, PoseStack matrix, MultiBufferSource bufferSource, RenderType renderType, double originX, double originY, double originZ, Colour colour) {
        VertexConsumer buffer = bufferSource.m_6299_(renderType);
        Matrix4f m = matrix.m_85850_().m_252922_();
        Matrix3f normal = matrix.m_85850_().m_252943_();
        float red = colour.glRed();
        float green = colour.glGreen();
        float blue = colour.glBlue();
        float alpha = colour.glAlpha();
        shape.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            float deltaX = (float)(x2 - x1);
            float deltaY = (float)(y2 - y1);
            float deltaZ = (float)(z2 - z1);
            float len = Mth.m_14116_((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
            buffer.m_252986_(m, (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).m_85950_(red, green, blue, alpha).m_252939_(normal, deltaX /= len, deltaY /= len, deltaZ /= len).m_5752_();
            buffer.m_252986_(m, (float)(x2 + originX), (float)(y2 + originY), (float)(z2 + originZ)).m_85950_(red, green, blue, alpha).m_252939_(normal, deltaX, deltaY, deltaZ).m_5752_();
        });
    }

    public static void paintSprite(GuiGraphics gfx, ISprite sprite, Point screenXY, int zLevel, int width, int height) {
        ModRenderHelper.paintSprite(gfx, sprite, screenXY.X, screenXY.Y, zLevel, width, height);
    }

    public static void paintSprite(GuiGraphics gfx, ISprite sprite, int x, int y, int zLevel, int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        gfx.m_280444_(sprite.getTextureMap().getTextureLocation(), x, x + width, y, y + height, zLevel, sprite.getMinU(), sprite.getMaxU(), sprite.getMinV(), sprite.getMaxV());
        RenderSystem.disableBlend();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(gfx, o, x, y, zLevel, width, height)));
    }

    public static void paintSprite(GuiGraphics gfx, ISprite sprite, int xOffset, int yOffset, int zLevel, Padding padding, int width, int height, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int x = xOffset + padding.getLeft() + maskLeft;
        int y = yOffset + padding.getTop() + maskTop;
        int u = sprite.getU() + maskLeft;
        int v = sprite.getV() + maskTop;
        int paintWidth = width - maskRight - maskLeft;
        int paintHeight = height - maskBottom - maskTop;
        float widthRatio = 1.0f / (float)sprite.getTextureMap().getWidth();
        float heightRatio = 1.0f / (float)sprite.getTextureMap().getHeight();
        gfx.m_280444_(sprite.getTextureMap().getTextureLocation(), x, x + paintWidth, y, y + paintHeight, zLevel, (float)u * widthRatio, ((float)u + (float)paintWidth) * widthRatio, (float)v * heightRatio, ((float)v + (float)paintHeight) * heightRatio);
        RenderSystem.disableBlend();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(gfx, o, xOffset, yOffset, zLevel, padding, width, height, maskTop, maskBottom, maskLeft, maskRight)));
    }

    public static void paintOrientedProgressBarSprite(GuiGraphics gfx, Orientation orientation, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress, Colour tint) {
        switch (orientation) {
            case BottomToTop: {
                ModRenderHelper.paintBottomToTopTiledSprite(gfx, sprite, tint, screenXY.X, screenXY.Y + area.Height, zLevel, area.Width, (int)((double)area.Height * progress));
                break;
            }
            case TopToBottom: {
                ModRenderHelper.paintTopToBottomTiledSprite(gfx, sprite, tint, screenXY.X, screenXY.Y, zLevel, area.Width, (int)((double)area.Height * progress));
                break;
            }
            case LeftToRight: {
                ModRenderHelper.paintLeftToRightTiledSprite(gfx, sprite, tint, screenXY.X, screenXY.Y, zLevel, (int)((double)area.Width * progress), area.Height);
                break;
            }
            case RightToLeft: {
                ModRenderHelper.paintRightToLeftTiledSprite(gfx, sprite, tint, screenXY.X + area.Width, screenXY.Y, zLevel, (int)((double)area.Width * progress), area.Height);
            }
        }
    }

    public static void paintOrientedProgressBarSprite(GuiGraphics gfx, Orientation orientation, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress, Colour tint) {
        switch (orientation) {
            case BottomToTop: {
                ModRenderHelper.paintBottomToTopTiledSprite(gfx, sprite, tint, x, y + areaHeight, zLevel, areaWidth, (int)((double)areaHeight * progress));
                break;
            }
            case TopToBottom: {
                ModRenderHelper.paintTopToBottomTiledSprite(gfx, sprite, tint, x, y, zLevel, areaWidth, (int)((double)areaHeight * progress));
                break;
            }
            case LeftToRight: {
                ModRenderHelper.paintLeftToRightTiledSprite(gfx, sprite, tint, x, y, zLevel, (int)((double)areaWidth * progress), areaHeight);
                break;
            }
            case RightToLeft: {
                ModRenderHelper.paintRightToLeftTiledSprite(gfx, sprite, tint, x + areaWidth, y, zLevel, (int)((double)areaWidth * progress), areaHeight);
            }
        }
    }

    public static void paintTopToBottomTiledSprite(GuiGraphics gfx, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172814_);
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int tileY1 = y + verticalTile * spriteHeight;
                int tileY2 = tileY1 + height;
                bufferBuilder.m_252986_(pose, (float)tileX1, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, tileMaxV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX2, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, tileMaxV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX2, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, spriteMinV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX1, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, spriteMinV).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void paintBottomToTopTiledSprite(GuiGraphics gfx, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172814_);
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMinV = spriteMaxV - deltaV * (float)height / (float)spriteHeight;
                int baseY = y - (verticalTile + 1) * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.m_252986_(pose, (float)tileX1, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, spriteMaxV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX2, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, spriteMaxV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX2, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, tileMinV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX1, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, tileMinV).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void paintLeftToRightTiledSprite(GuiGraphics gfx, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172814_);
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int baseY = y + verticalTile * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.m_252986_(pose, (float)tileX1, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, tileMaxV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX2, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, tileMaxV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX2, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMaxU, spriteMinV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX1, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMinU, spriteMinV).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void paintRightToLeftTiledSprite(GuiGraphics gfx, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172814_);
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMinU = spriteMaxU - deltaU * (float)width / (float)spriteWidth;
            int tileX2 = x - horizontalTile * spriteWidth;
            int tileX1 = tileX2 - spriteWidth + skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int baseY = y + verticalTile * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.m_252986_(pose, (float)tileX1, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMinU, tileMaxV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX2, (float)tileY2, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMaxU, tileMaxV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX2, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(spriteMaxU, spriteMinV).m_5752_();
                bufferBuilder.m_252986_(pose, (float)tileX1, (float)tileY1, (float)zLevel).m_6122_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).m_7421_(tileMinU, spriteMinV).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void paintSolidRect(GuiGraphics gfx, Point screenXY1, Point screenXY2, int zLevel, Colour colour) {
        gfx.m_285795_(RenderTypes.m_285907_(), screenXY1.X, screenXY1.Y, screenXY2.X, screenXY2.Y, zLevel, colour.toARGB());
    }

    public static void paintSolidRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, int zLevel, Colour colour) {
        gfx.m_285795_(RenderType.m_285907_(), x1, y1, x2, y2, zLevel, colour.toARGB());
    }

    public static void paintHollowRect(GuiGraphics gfx, Point screenXY, int width, int height, int zLevel, Colour colour) {
        ModRenderHelper.paintHollowRect(gfx, screenXY.X, screenXY.Y, width, height, zLevel, colour);
    }

    public static void paintHollowRect(GuiGraphics gfx, int x1, int y1, int width, int height, int zLevel, Colour colour) {
        ModRenderHelper.paintHorizontalLine(gfx, x1, y1, width, zLevel, colour);
        ModRenderHelper.paintVerticalLine(gfx, x1 + width - 1, y1 + 1, height - 2, zLevel, colour);
        ModRenderHelper.paintHorizontalLine(gfx, x1, y1 + height - 1, width, zLevel, colour);
        ModRenderHelper.paintVerticalLine(gfx, x1, y1 + 1, height - 2, zLevel, colour);
    }

    public static void paintTriangularGradientRect(GuiGraphics gfx, int x, int y, int width, int height, int zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        builder.m_252986_(pose, (float)x2, (float)y, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x, (float)y, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x, (float)y2, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void paintHorizontalLine(GuiGraphics gfx, Point screenXY, int length, int zLevel, Colour colour) {
        gfx.m_285795_(RenderTypes.m_285907_(), screenXY.X, screenXY.Y, screenXY.X + length + 1, screenXY.Y + 1, zLevel, colour.toARGB());
    }

    public static void paintHorizontalLine(GuiGraphics gfx, int x, int y, int length, int zLevel, Colour colour) {
        gfx.m_285795_(RenderTypes.m_285907_(), x, y, x + length, y + 1, zLevel, colour.toARGB());
    }

    public static void paintVerticalLine(GuiGraphics gfx, Point screenXY, int length, int zLevel, Colour colour) {
        gfx.m_285795_(RenderTypes.m_285907_(), screenXY.X, screenXY.Y, screenXY.X + 1, screenXY.Y + length + 1, zLevel, colour.toARGB());
    }

    public static void paintVerticalLine(GuiGraphics gfx, int x, int y, int length, int zLevel, Colour colour) {
        gfx.m_285795_(RenderTypes.m_285907_(), x, y, x + 1, y + length, zLevel, colour.toARGB());
    }

    public static void paintButton3D(GuiGraphics gfx, Point screenXY, int width, int height, int zLevel, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintButton3D(gfx, screenXY.X, screenXY.Y, width, height, zLevel, darkOutlineColour, gradientLightColour, gradientDarkColour, borderLightColour, borderDarkColour);
    }

    public static void paintButton3D(GuiGraphics gfx, int x, int y, int width, int height, int zLevel, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintHollowRect(gfx, x, y, width, height, zLevel, darkOutlineColour);
        ModRenderHelper.paintTriangularGradientRect(gfx, x + 2, y + 2, width - 3, height - 3, zLevel, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintHorizontalLine(gfx, x + 1, y + 1, width - 2, zLevel, borderLightColour);
        ModRenderHelper.paintVerticalLine(gfx, x + 1, y + 1, height - 3, zLevel, borderLightColour);
        ModRenderHelper.paintHorizontalLine(gfx, x + 1, y + height - 2, width - 2, zLevel, borderDarkColour);
        ModRenderHelper.paintVerticalLine(gfx, x + width - 2, y + 2, height - 3, zLevel, borderDarkColour);
    }

    public static void paintButton3D(GuiGraphics gfx, Point screenXY, int width, int height, int zLevel, Colour darkOutlineColour, Colour flatBackgroundColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintButton3D(gfx, screenXY.X, screenXY.Y, width, height, zLevel, darkOutlineColour, flatBackgroundColour, borderLightColour, borderDarkColour);
    }

    public static void paintButton3D(GuiGraphics gfx, int x, int y, int width, int height, int zLevel, Colour darkOutlineColour, Colour flatBackgroundColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintHollowRect(gfx, x, y, width, height, zLevel, darkOutlineColour);
        ModRenderHelper.paintSolidRect(gfx, x + 2, y + 2, x + 2 + width - 3, y + 2 + height - 3, zLevel, flatBackgroundColour);
        ModRenderHelper.paintHorizontalLine(gfx, x + 1, y + 1, width - 2, zLevel, borderLightColour);
        ModRenderHelper.paintVerticalLine(gfx, x + 1, y + 1, height - 3, zLevel, borderLightColour);
        ModRenderHelper.paintHorizontalLine(gfx, x + 1, y + height - 2, width - 2, zLevel, borderDarkColour);
        ModRenderHelper.paintVerticalLine(gfx, x + width - 2, y + 2, height - 3, zLevel, borderDarkColour);
    }

    public static void paintMessage(GuiGraphics gfx, IRichText message, int x, int y, int zLevel, int margin, Colour background, Colour highlight1, Colour highlight2) {
        Rectangle boxBounds = message.bounds().expand(margin * 2, margin * 2).offset(x, y);
        ModRenderHelper.paintVerticalLine(gfx, boxBounds.getX1(), boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, background);
        ModRenderHelper.paintSolidRect(gfx, boxBounds.getX1() + 1, boxBounds.getY1(), boxBounds.getX2(), boxBounds.getY2() + 1, zLevel, background);
        ModRenderHelper.paintVerticalLine(gfx, boxBounds.getX2(), boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, background);
        ModRenderHelper.paintVerticalGradientLine(gfx, boxBounds.getX1() + 1, boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(gfx, boxBounds.getX1() + 2, boxBounds.getY1() + 1, boxBounds.Width - 4, zLevel, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(gfx, boxBounds.getX1() + 2, boxBounds.getY2() - 1, boxBounds.Width - 4, zLevel, highlight1, highlight2);
        ModRenderHelper.paintVerticalGradientLine(gfx, boxBounds.getX2() - 1, boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, highlight1, highlight2);
        message.paint(gfx, boxBounds.getX1() + margin, boxBounds.getY1() + margin, zLevel + 1);
    }

    public static boolean paintItemStack(GuiGraphics gfx, ItemStack stack, int x, int y, String text, boolean highlight) {
        if (stack.m_41619_()) {
            return false;
        }
        if (highlight) {
            ModRenderHelper.paintSolidRect(gfx, x, y, x + 16, y + 16, 599, Colour.fromARGB(-2130706433));
        }
        gfx.m_280480_(stack, x, y);
        gfx.m_280302_(Minecraft.m_91087_().f_91062_, stack, x + 4, y, text);
        return true;
    }

    public static boolean paintItemStackWithCount(GuiGraphics gfx, ItemStack stack, int x, int y, boolean highlight) {
        return !stack.m_41619_() && ModRenderHelper.paintItemStack(gfx, stack, x, y, CodeHelper.formatAsHumanReadableNumber(stack.m_41613_(), ""), highlight);
    }

    public static void paintSolidLines(GuiGraphics gfx, Colour colour, double thickness, double zLevel, double ... vertices) {
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        float halfThickness = (float)(thickness / 2.0);
        int verticesCount = vertices.length;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        int i = 0;
        while (i < verticesCount) {
            float swap;
            float x1 = (float)vertices[i++];
            float y1 = (float)vertices[i++];
            float x2 = (float)vertices[i++];
            float y2 = (float)vertices[i++];
            if (x1 == x2) {
                if (y2 < y1) {
                    swap = y1;
                    y1 = y2;
                    y2 = swap;
                }
                builder.m_252986_(pose, x1 - halfThickness, y1 - halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                builder.m_252986_(pose, x1 - halfThickness, y2 + halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                builder.m_252986_(pose, x1 + halfThickness, y1 - halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                builder.m_252986_(pose, x1 + halfThickness, y2 + halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                continue;
            }
            if (y1 == y2) {
                if (x2 < x1) {
                    swap = x1;
                    x1 = x2;
                    x2 = swap;
                }
                builder.m_252986_(pose, x1 - halfThickness, y1 - halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                builder.m_252986_(pose, x1 - halfThickness, y1 + halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                builder.m_252986_(pose, x2 + halfThickness, y1 - halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                builder.m_252986_(pose, x2 + halfThickness, y1 + halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                continue;
            }
            if (x1 < x2 && y1 < y2 || x2 < x1 && y2 < y1) {
                if (x2 < x1) {
                    swap = x1;
                    x1 = x2;
                    x2 = swap;
                    swap = y1;
                    y1 = y2;
                    y2 = swap;
                }
                builder.m_252986_(pose, x1 + halfThickness, y1 - halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                builder.m_252986_(pose, x1 - halfThickness, y1 + halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                builder.m_252986_(pose, x2 + halfThickness, y2 - halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                builder.m_252986_(pose, x2 - halfThickness, y2 + halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
                continue;
            }
            if (x1 < x2) {
                swap = x1;
                x1 = x2;
                x2 = swap;
                swap = y1;
                y1 = y2;
                y2 = swap;
            }
            builder.m_252986_(pose, x1 + halfThickness, y1 + halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
            builder.m_252986_(pose, x1 - halfThickness, y1 - halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
            builder.m_252986_(pose, x2 + halfThickness, y2 + halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
            builder.m_252986_(pose, x2 - halfThickness, y2 - halfThickness, (float)zLevel).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void paintSolidRects(GuiGraphics gfx, Colour colour, double zLevel, int ... vertices) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        ModRenderHelper.glSetColour(colour);
        RenderSystem.setShader(GameRenderer::m_172808_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        int verticesCount = vertices.length;
        for (int i = 0; i < verticesCount; i += 4) {
            int x1 = vertices[i];
            int y1 = vertices[i + 1];
            int x2 = vertices[i + 2];
            int y2 = vertices[i + 3];
            builder.m_252986_(pose, (float)x1, (float)y2, (float)zLevel).m_5752_();
            builder.m_252986_(pose, (float)x2, (float)y2, (float)zLevel).m_5752_();
            builder.m_252986_(pose, (float)x2, (float)y1, (float)zLevel).m_5752_();
            builder.m_252986_(pose, (float)x1, (float)y1, (float)zLevel).m_5752_();
        }
        tessellator.m_85914_();
        GlStateManager._disableBlend();
    }

    public static void paintSolidTriangles(GuiGraphics gfx, Colour colour, double zLevel, int ... vertices) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        ModRenderHelper.glSetColour(colour);
        RenderSystem.setShader(GameRenderer::m_172808_);
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85814_);
        int verticesCount = vertices.length;
        for (int i = 0; i < verticesCount; i += 6) {
            int x1 = vertices[i];
            int y1 = vertices[i + 1];
            int x2 = vertices[i + 2];
            int y2 = vertices[i + 3];
            int x3 = vertices[i + 4];
            int y3 = vertices[i + 5];
            builder.m_252986_(pose, (float)x1, (float)y1, (float)zLevel).m_5752_();
            builder.m_252986_(pose, (float)x2, (float)y2, (float)zLevel).m_5752_();
            builder.m_252986_(pose, (float)x3, (float)y3, (float)zLevel).m_5752_();
        }
        tessellator.m_85914_();
        GlStateManager._disableBlend();
    }

    public static void paintHorizontalGradientLine(GuiGraphics gfx, int x, int y, int length, double zLevel, Colour startColour, Colour endColour) {
        ModRenderHelper.paintHorizontalGradientRect(gfx, x, y, x + length, y + 1, zLevel, startColour, endColour);
    }

    public static void paintVerticalGradientLine(GuiGraphics gfx, int x, int y, int length, double zLevel, Colour startColour, Colour endColour) {
        ModRenderHelper.paintVerticalGradientRect(gfx, x, y, x + 1, y + length, zLevel, startColour, endColour);
    }

    public static void paintVerticalGradientRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour startColour, Colour endColour) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float startAlpha = startColour.glAlpha();
        float startRed = startColour.glRed();
        float startGreen = startColour.glGreen();
        float startBlue = startColour.glBlue();
        float endAlpha = endColour.glAlpha();
        float endRed = endColour.glRed();
        float endGreen = endColour.glGreen();
        float endBlue = endColour.glBlue();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_252986_(pose, (float)x2, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x1, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_252986_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void paintHorizontalGradientRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour startColour, Colour endColour) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float startAlpha = startColour.glAlpha();
        float startRed = startColour.glRed();
        float startGreen = startColour.glGreen();
        float startBlue = startColour.glBlue();
        float endAlpha = endColour.glAlpha();
        float endRed = endColour.glRed();
        float endGreen = endColour.glGreen();
        float endBlue = endColour.glBlue();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_252986_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x1, (float)y2, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_252986_(pose, (float)x2, (float)y1, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void paint3DGradientRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_252986_(pose, (float)x2, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x1, (float)y2, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void paint3DGradientTriangle(GuiGraphics gfx, double x1, double y1, double x2, double y2, double x3, double y3, double zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        builder.m_252986_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_252986_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x3, (float)y3, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void paint3DGradientTriangle(GuiGraphics gfx, double x1, double y1, double x2, double y2, double x3, double y3, double zLevel, Colour colour1, Colour colour2, Colour colour3) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        builder.m_252986_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(colour2.glRed(), colour2.glGreen(), colour2.glBlue(), colour2.glAlpha()).m_5752_();
        builder.m_252986_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(colour1.glRed(), colour1.glGreen(), colour1.glBlue(), colour1.glAlpha()).m_5752_();
        builder.m_252986_(pose, (float)x3, (float)y3, (float)zLevel).m_85950_(colour3.glRed(), colour3.glGreen(), colour3.glBlue(), colour3.glAlpha()).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void paint3DSolidTriangle(GuiGraphics gfx, double x1, double y1, double x2, double y2, double x3, double y3, double zLevel, Colour colour) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        float startAlpha = colour.glAlpha();
        float startRed = colour.glRed();
        float startGreen = colour.glGreen();
        float startBlue = colour.glBlue();
        float endAlpha = colour.glAlpha();
        float endRed = colour.glRed();
        float endGreen = colour.glGreen();
        float endBlue = colour.glBlue();
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        builder.m_252986_(pose, (float)x1, (float)y1, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_252986_(pose, (float)x3, (float)y3, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_252986_(pose, (float)x2, (float)y2, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void paint3DSunkenBox(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paint3DGradientRect(gfx, x1 + 1, y1 + 1, x2 - 1, y2 - 1, zLevel, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintSolidRects(gfx, borderDarkColour, zLevel, x1, y1, x2, y1 + 1, x1, y1, x1 + 1, y2);
        ModRenderHelper.paintSolidRects(gfx, borderLightColour, zLevel, x1, y2 - 1, x2, y2, x2 - 1, y1, x2, y2);
    }

    public static void paint3DSunkenBox(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour gradientLightColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintSolidRect(gfx, x1 + 1, y1 + 1, x2 - 1, y2 - 1, (int)zLevel, gradientLightColour);
        ModRenderHelper.paintSolidRects(gfx, borderDarkColour, zLevel, x1, y1, x2, y1 + 1, x1, y1, x1 + 1, y2);
        ModRenderHelper.paintSolidRects(gfx, borderLightColour, zLevel, x1, y2 - 1, x2, y2, x2 - 1, y1, x2, y2);
    }

    public static void glSetColour(Colour colour) {
        RenderSystem.setShaderColor((float)colour.glRed(), (float)colour.glGreen(), (float)colour.glBlue(), (float)colour.glAlpha());
    }

    public static void glSetViewport(int x, int y, int width, int height) {
        RenderSystem.viewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void glSetViewport(double x, double y, double width, double height) {
        RenderSystem.viewport((int)Mth.m_14107_((double)x), (int)Mth.m_14107_((double)y), (int)Mth.m_14107_((double)width), (int)Mth.m_14107_((double)height));
    }

    public static void glSetDefaultViewport() {
        RenderSystem.viewport((int)0, (int)0, (int)Minecraft.m_91087_().m_91268_().m_85441_(), (int)Minecraft.m_91087_().m_91268_().m_85442_());
    }

    public static Matrix4f glPerspectiveMatrix(float fov, float aspect, float zNear, float zFar) {
        return new Matrix4f().perspective(fov, aspect, zNear, zFar);
    }

    public static IntIntPair getAtlasDimensions(TextureAtlasSprite sprite) {
        Preconditions.checkNotNull((Object)sprite, (Object)"Sprite must not be null");
        SpriteContents contents = sprite.m_245424_();
        int atlasWidth = (int)((float)contents.m_246492_() / (sprite.m_118410_() - sprite.m_118409_()));
        int atlasHeight = (int)((float)contents.m_245330_() / (sprite.m_118412_() - sprite.m_118411_()));
        return IntIntPair.of((int)atlasWidth, (int)atlasHeight);
    }

    public static void dumpAtlas(ResourceLocation id) {
        Preconditions.checkNotNull((Object)id, (Object)"Id must not be null");
        TextureAtlas atlas = (TextureAtlas)Preconditions.checkNotNull((Object)Minecraft.m_91087_().m_91304_().m_119428_(id), (String)"Atlas with ID %s was not found", (Object)id);
        ModRenderHelper.dumpAtlas(atlas);
    }

    public static void dumpAtlas(TextureAtlas atlas) {
        Preconditions.checkNotNull((Object)atlas, (Object)"Atlas must not be null");
        List<TextureAtlasSprite> sprites = atlas.getTextureLocations().stream().map(arg_0 -> ((TextureAtlas)atlas).m_118316_(arg_0)).sorted((s1, s2) -> s1.m_174743_() == s2.m_174743_() ? s1.m_174744_() - s2.m_174744_() : s1.m_174743_() - s2.m_174743_()).toList();
        if (sprites.isEmpty()) {
            Log.LOGGER.warn(Log.CLIENT, "Atlas {} is empty: nothing to dump", (Object)atlas.m_118330_());
            return;
        }
        String filename = atlas.m_118330_().m_179910_();
        Path path = TextureUtil.getDebugTexturePath();
        try {
            IntIntPair dimensions = ModRenderHelper.getAtlasDimensions(sprites.get(0));
            Files.createDirectories(path, new FileAttribute[0]);
            TextureUtil.writeAsPNG((Path)path, (String)filename, (int)atlas.m_117963_(), (int)0, (int)dimensions.firstInt(), (int)dimensions.secondInt());
            path = path.resolve(filename + "_sprites.txt");
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
                writer.println("#\tID\tX\tY\tWidth\tHeight");
                int count = 0;
                for (TextureAtlasSprite sprite : sprites) {
                    SpriteContents contents = sprite.m_245424_();
                    writer.println(String.format("%d\t%s\t%d\t%d\t%d\t%d", ++count, contents.m_246162_(), sprite.m_174743_(), sprite.m_174744_(), contents.m_246492_(), contents.m_245330_()));
                }
            }
            catch (IOException ex) {
                Log.LOGGER.warn(Log.CLIENT, "Failed to write sprites data to {} : {}", (Object)path, (Object)ex);
            }
        }
        catch (IOException ex) {
            Log.LOGGER.warn(Log.CLIENT, "Failed to dump atlas to {} : {}", (Object)path, (Object)ex);
        }
    }

    private ModRenderHelper() {
    }
}

