/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.zerono.mods.zerocore.lib.compat.patchouli.Patchouli;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.AbstractStandardPageComponent;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageEmpty;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;

public class Multiblock
extends AbstractStandardPageComponent<PageEmpty> {
    String name = "";
    @SerializedName(value="multiblock_id")
    String multiblockId;
    private transient Book book;
    private transient GuiBookEntry parent;
    private transient AbstractMultiblock multiblockObj;
    public transient Minecraft mc;
    private static final RandomSource RAND = RandomSource.m_216327_();

    protected Multiblock() {
        super(new PageEmpty());
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        super.onVariablesAvailable(lookup);
        this.multiblockId = ((IVariable)lookup.apply(IVariable.wrap((String)this.multiblockId))).asString();
    }

    @Override
    public void build(BookContentsBuilder builder, BookPage page, BookEntry entry, int pageNum) {
        IMultiblock mb;
        this.book = page.book;
        if (this.multiblockId != null && (mb = (IMultiblock)MultiblockRegistry.MULTIBLOCKS.get(new ResourceLocation(this.multiblockId))) instanceof AbstractMultiblock) {
            this.multiblockObj = (AbstractMultiblock)mb;
        }
        if (this.multiblockObj == null) {
            throw new IllegalArgumentException("No multiblock located for " + this.multiblockId);
        }
    }

    @Override
    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
        this.parent = parent;
        this.mc = parent.getMinecraft();
    }

    @Override
    protected void renderPage(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = 5;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture((GuiGraphics)graphics, (Book)this.book, (int)x, (int)y, (int)405, (int)149, (int)106, (int)106);
        this.parent.drawCenteredStringNoShadow(graphics, this.name, 58, 0, this.book.headerColor);
        if (this.multiblockObj != null) {
            this.renderMultiblock(graphics);
        }
    }

    private void renderMultiblock(GuiGraphics graphics) {
        this.multiblockObj.setWorld((Level)this.mc.f_91073_);
        PoseStack ms = graphics.m_280168_();
        Vec3i size = this.multiblockObj.getSize();
        int sizeX = size.m_123341_();
        int sizeY = size.m_123342_();
        int sizeZ = size.m_123343_();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 58;
        int yPos = 60;
        ms.m_85836_();
        ms.m_252880_((float)xPos, (float)yPos, 100.0f);
        ms.m_85841_(scale, scale, scale);
        ms.m_252880_(-((float)sizeX) / 2.0f, -((float)sizeY) / 2.0f, 0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        ms.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        rotMat.rotation((Quaternionfc)Axis.f_252529_.m_252977_(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parent.ticksInBook * 0.5f;
        if (!Screen.m_96638_()) {
            time += ClientTicker.partialTicks;
        }
        ms.m_252880_(-offX, 0.0f, -offZ);
        ms.m_252781_(Axis.f_252436_.m_252977_(time));
        rotMat.rotation((Quaternionfc)Axis.f_252436_.m_252977_(-time));
        ms.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        rotMat.rotation((Quaternionfc)Axis.f_252436_.m_252977_(-45.0f));
        ms.m_252880_(offX, 0.0f, offZ);
        eye.mul((Matrix4fc)rotMat);
        this.renderElements(ms, this.multiblockObj, BlockPos.m_121940_((BlockPos)BlockPos.f_121853_, (BlockPos)new BlockPos(sizeX - 1, sizeY - 1, sizeZ - 1)), eye);
        ms.m_85849_();
    }

    private void renderElements(PoseStack ms, AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, Vector4f eye) {
        ms.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.m_252880_(0.0f, 0.0f, -1.0f);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        this.doWorldRenderPass(ms, mb, blocks, buffers, eye);
        buffers.m_109911_();
        ms.m_85849_();
    }

    private void doWorldRenderPass(PoseStack ms, AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, MultiBufferSource.BufferSource buffers, Vector4f eye) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        for (BlockPos blockPos : blocks) {
            BlockState bs = mb.m_8055_(blockPos);
            BlockState renderBlockState = Patchouli.getRenderBlockStateFor((IMultiblock)mb, bs);
            ModelData renderModelData = Patchouli.getModelDataFor((IMultiblock)mb, bs);
            VertexConsumer buffer = buffers.m_6299_(ItemBlockRenderTypes.m_109282_((BlockState)bs));
            ms.m_85836_();
            ms.m_252880_((float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_());
            blockRenderer.renderBatched(renderBlockState, blockPos, (BlockAndTintGetter)mb, ms, buffer, false, RAND, renderModelData, null);
            ms.m_85849_();
        }
    }
}

