/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.stack;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.EnumIndexedArray;
import it.zerono.mods.zerocore.lib.data.nbt.IMergeableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IStackAdapter;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fml.LogicalSide;

public class IndexedStackContainer<Index extends Enum<Index>, Content, Stack>
implements ISyncableEntity,
IMergeableEntity,
IDebuggable {
    private static final int FORCE_UPDATE = -1000;
    private final IStackAdapter<Stack, Content> _adapter;
    private final EnumIndexedArray<Index, Stack> _stacks;
    private final EnumIndexedArray<Index, Integer> _lastSeenLevels;
    private int _capacity;
    private final boolean _sharedCapacity;
    private final int _minimumTicksBetweenUpdates;
    private int _ticksSinceLastUpdate;

    @SafeVarargs
    public IndexedStackContainer(int capacity, IStackAdapter<Stack, Content> stackAdapter, Index firstValidIndex, Index secondValidIndex, Index ... otherValidIndices) {
        this(capacity, false, 60, stackAdapter, (Enum)firstValidIndex, (Enum)secondValidIndex, (Enum[])otherValidIndices);
    }

    @SafeVarargs
    public IndexedStackContainer(int capacity, boolean capacityIsShared, int minimumTicksBetweenUpdates, IStackAdapter<Stack, Content> stackAdapter, Index firstValidIndex, Index secondValidIndex, Index ... otherValidIndices) {
        this._capacity = capacity;
        this._sharedCapacity = capacityIsShared;
        this._minimumTicksBetweenUpdates = minimumTicksBetweenUpdates;
        this._adapter = stackAdapter;
        this._stacks = new EnumIndexedArray(this.getStackAdapter()::createArray, firstValidIndex, secondValidIndex, otherValidIndices);
        this._lastSeenLevels = new EnumIndexedArray(Integer[]::new, firstValidIndex, secondValidIndex, otherValidIndices);
        Stack empty = this.getStackAdapter().getEmptyStack();
        this.getValidIndexes().forEach(type -> {
            this.setStack(type, empty);
            this.setLastSeenLevel(type, -1000);
        });
    }

    public int getCapacity() {
        return this._capacity;
    }

    public void setCapacity(int capacity) {
        this._capacity = capacity;
        this.clampContentsToCapacity();
    }

    public boolean isCapacityShared() {
        return this._sharedCapacity;
    }

    public int getTotalAmount() {
        return this.getValidIndexes().stream().mapToInt(type -> this.getStackAdapter().getAmount(this.getStack(type))).sum();
    }

    public int getFreeSpace(Index index) {
        return this.getCapacity() - (this.isCapacityShared() ? this.getTotalAmount() : this.getContentAmount(index));
    }

    public Stack getStackCopy(Index index) {
        Stack currentStack;
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        return adapter.isEmpty(currentStack = this.getStack(index)) ? adapter.getEmptyStack() : adapter.create(currentStack);
    }

    public Optional<Content> getContent(Index index) {
        return this.getStackAdapter().getContent(this.getStack(index));
    }

    public int getContentAmount(Index index) {
        return this.getStackAdapter().getAmount(this.getStack(index));
    }

    public <T> T map(Index type, Function<Content, T> mapper, T defaultValue) {
        return (T)this._stacks.map(type, (Element stack) -> this.getStackAdapter().map(stack, mapper, defaultValue), defaultValue);
    }

    public <T> T map(Index type, IntFunction<T> mapper, T defaultValue) {
        return (T)this._stacks.map(type, (Element stack) -> this.getStackAdapter().map(stack, mapper, defaultValue), defaultValue);
    }

    public <T> T map(Index type, BiFunction<Content, Integer, T> mapper, T defaultValue) {
        return (T)this._stacks.map(type, (Element stack) -> this.getStackAdapter().map(stack, mapper, defaultValue), defaultValue);
    }

    public void accept(Index type, Consumer<Content> consumer) {
        this._stacks.accept(type, (Element stack) -> this.getStackAdapter().accept(stack, consumer));
    }

    public void accept(Index type, IntConsumer consumer) {
        this._stacks.accept(type, (Element stack) -> this.getStackAdapter().accept(stack, consumer));
    }

    public void accept(Index type, BiConsumer<Content, Integer> consumer) {
        this._stacks.accept(type, (Element stack) -> this.getStackAdapter().accept(stack, consumer));
    }

    public boolean shouldUpdate() {
        ++this._ticksSinceLastUpdate;
        if (this._minimumTicksBetweenUpdates < this._ticksSinceLastUpdate) {
            IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
            int deviance = 0;
            boolean shouldUpdate = false;
            for (Enum index : this.getValidIndexes()) {
                Stack stack = this.getStack(index);
                int lastLevel = this.getLastSeenLevel(index);
                if (adapter.isEmpty(stack) && lastLevel > 0) {
                    shouldUpdate = true;
                } else if (!adapter.isEmpty(stack)) {
                    if (-1000 == lastLevel) {
                        shouldUpdate = true;
                    } else {
                        deviance += Math.abs(adapter.getAmount(stack) - lastLevel);
                    }
                }
                if (!(shouldUpdate = this.evaluateUpdate(deviance, shouldUpdate))) continue;
                break;
            }
            if (shouldUpdate) {
                this.updateLastSeenLevels();
            }
            this._ticksSinceLastUpdate = 0;
            return shouldUpdate;
        }
        return false;
    }

    protected boolean evaluateUpdate(int currentDeviance, boolean currentUpdateValuation) {
        return currentUpdateValuation;
    }

    protected void onInsert(Index index, boolean wasEmpty) {
    }

    protected void onExtract(Index index, boolean isEmptyNow) {
    }

    public boolean canInsert(Index index) {
        return true;
    }

    public boolean canExtract(Index index) {
        return true;
    }

    public boolean isContentCompatible(Index index, Content content) {
        IStackAdapter adapter = this.getStackAdapter();
        Optional<Content> currentContent = adapter.getContent(this.getStack(index));
        return currentContent.map(c -> adapter.isContentEqual(c, content)).orElseGet(() -> this.isContentValidForIndex(index, content));
    }

    public boolean isStackCompatible(Index index, Stack stack) {
        Stack currentStack;
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        if (!adapter.isEmpty(currentStack = this.getStack(index))) {
            return adapter.isStackContentEqual(currentStack, stack);
        }
        return this.isStackValidForIndex(index, stack);
    }

    public boolean isStackValidForIndex(Index index, Stack stack) {
        return true;
    }

    public boolean isContentValidForIndex(Index index, Content content) {
        return true;
    }

    public int insert(Index index, Stack stack, OperationMode mode) {
        int amountToAdd;
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        if (this.canInsert(index) && !adapter.isEmpty(stack) && this.isStackCompatible(index, stack) && (amountToAdd = Math.min(adapter.getAmount(stack), this.getFreeSpace(index))) > 0) {
            return this.insert(index, mode, adapter.create(stack), amountToAdd);
        }
        return 0;
    }

    public int insert(Index index, Content content, int amount, OperationMode mode) {
        int amountToAdd;
        if (this.canInsert(index) && amount > 0 && this.isContentCompatible(index, content) && (amountToAdd = Math.min(amount, this.getFreeSpace(index))) > 0) {
            return this.insert(index, mode, this.getStackAdapter().create(content, amountToAdd), amountToAdd);
        }
        return 0;
    }

    public int insert(Index index, int amount, OperationMode mode) {
        return this.getContent(index).map(content -> this.insert(index, content, amount, mode)).orElse(0);
    }

    public Stack extract(Index index, Stack stack, OperationMode mode) {
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        if (this.canExtract(index) && !adapter.isEmpty(stack) && this.isStackCompatible(index, stack)) {
            return this.extract(index, mode, adapter.create(stack));
        }
        return adapter.getEmptyStack();
    }

    public Stack extract(Index index, Content content, int amount, OperationMode mode) {
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        if (this.canExtract(index) && amount > 0 && this.isContentCompatible(index, content)) {
            return this.extract(index, mode, adapter.create(content, amount));
        }
        return adapter.getEmptyStack();
    }

    public Stack extract(Index index, int amount, OperationMode mode) {
        return (Stack)this.getContent(index).map(content -> this.extract(index, content, amount, mode)).orElse(this.getStackAdapter().getEmptyStack());
    }

    public Stack clear(Index index) {
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        Stack currentStack = this.getStack(index);
        if (this.canExtract(index) && !adapter.isEmpty(currentStack)) {
            this.setStack(index, adapter.getEmptyStack());
            this.onExtract(index, true);
            return currentStack;
        }
        return adapter.getEmptyStack();
    }

    @Override
    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        for (Enum index : this.getValidIndexes()) {
            Stack stack;
            if (data.m_128441_(index.name())) {
                stack = adapter.readFrom(data.m_128469_(index.name()));
            } else {
                stack = adapter.getEmptyStack();
                Log.LOGGER.debug(Log.CORE, "{} data not found while loading a stack container from NBT data", (Object)index);
            }
            this.setStack(index, stack);
            this.setLastSeenLevel(index, -1000);
        }
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        this.getValidIndexes().forEach(index -> data.m_128365_(index.name(), (Tag)adapter.writeTo(this.getStack(index), new CompoundTag())));
        return data;
    }

    @Override
    public void syncDataFrom(IMergeableEntity other) {
        IndexedStackContainer otherContainer;
        if (other instanceof IndexedStackContainer && (otherContainer = (IndexedStackContainer)other).getCapacity() > this.getCapacity()) {
            this.setCapacity(otherContainer.getCapacity());
            this.getValidIndexes().forEach(index -> this.setStack(index, otherContainer.getStack(index)));
        }
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        messages.addUnlocalized("Container capacity: %1$s", CodeHelper.formatAsHumanReadableNumber((double)this.getCapacity() / 1000.0, "B"));
        this.getValidIndexes().forEach(index -> {
            Stack stack = this.getStack(index);
            messages.addUnlocalized("[%1$s] %2$s: %3$d", index, adapter.isEmpty(stack) ? "<EMPTY>" : adapter.getContent(stack).map(Object::toString).orElse("<EMPTY STACK>"), adapter.getAmount(stack));
        });
    }

    public String toString() {
        return "Capacity: " + this._capacity + ", Shared: " + this._sharedCapacity + "\nStacks: " + this._stacks;
    }

    protected IStackAdapter<Stack, Content> getStackAdapter() {
        return this._adapter;
    }

    protected List<Index> getValidIndexes() {
        return this._stacks.getValidIndices();
    }

    protected Stack getStack(Index index) {
        return this._stacks.getElement(index).orElse(this.getStackAdapter().getEmptyStack());
    }

    protected void setStack(Index index, Stack stack) {
        this._stacks.setElement(index, stack);
    }

    protected int getLastSeenLevel(Index index) {
        return this._lastSeenLevels.getElement(index).orElse(0);
    }

    protected void setLastSeenLevel(Index index, int level) {
        this._lastSeenLevels.setElement(index, level);
    }

    protected void updateLastSeenLevels() {
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        this.getValidIndexes().forEach(type -> {
            Stack stack = this.getStack(type);
            this.setLastSeenLevel(type, adapter.isEmpty(stack) ? 0 : adapter.getAmount(stack));
        });
    }

    protected void clampContentsToCapacity() {
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        int capacity = this.getCapacity();
        if (this.isCapacityShared()) {
            if (this.getTotalAmount() > capacity) {
                Enum index2;
                int excess = this.getTotalAmount() - capacity;
                Iterator<Index> iterator = this.getValidIndexes().iterator();
                while (iterator.hasNext() && (excess = this.reduceStackExcess(index2 = (Enum)iterator.next(), excess)) > 0) {
                }
            }
        } else {
            this.getValidIndexes().forEach(index -> {
                Stack stack = this.getStack(index);
                if (!adapter.isEmpty(stack)) {
                    adapter.setAmount(stack, Math.min(capacity, adapter.getAmount(stack)));
                }
            });
        }
    }

    private int reduceStackExcess(Index index, int excess) {
        Stack stack;
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        if (!adapter.isEmpty(stack = this.getStack(index))) {
            int amount = adapter.getAmount(stack);
            if (excess > amount) {
                excess -= amount;
                this.setStack(index, adapter.getEmptyStack());
            } else {
                adapter.modifyAmount(stack, -excess);
                excess = 0;
            }
        }
        return excess;
    }

    protected int insert(Index index, OperationMode mode, Stack stackCopy, int amountToAdd) {
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        if (mode.execute()) {
            Stack currentStack = this.getStack(index);
            if (adapter.isEmpty(currentStack)) {
                adapter.setAmount(stackCopy, amountToAdd);
                this.setStack(index, stackCopy);
                this.onInsert(index, true);
            } else {
                adapter.modifyAmount(currentStack, amountToAdd);
                this.onInsert(index, false);
            }
        }
        return amountToAdd;
    }

    protected Stack extract(Index index, OperationMode mode, Stack stackCopy) {
        Stack currentStack;
        IStackAdapter<Stack, Content> adapter = this.getStackAdapter();
        if (!adapter.isEmpty(currentStack = this.getStack(index))) {
            int currentAmount = adapter.getAmount(currentStack);
            int amountToRemove = Math.min(currentAmount, adapter.getAmount(stackCopy));
            if (mode.execute()) {
                if (currentAmount == amountToRemove) {
                    this.setStack(index, adapter.getEmptyStack());
                    this.onExtract(index, true);
                } else {
                    adapter.modifyAmount(currentStack, -amountToRemove);
                    this.onExtract(index, false);
                }
            }
            return adapter.setAmount(stackCopy, amountToRemove);
        }
        return adapter.getEmptyStack();
    }
}

