/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.entities;

import net.jacobwasbeast.picaxe.ModBlockEntities;
import net.jacobwasbeast.picaxe.api.BedRenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ImageBedBlockEntity
extends BlockEntity {
    public DyeColor color;
    private String imageLocation;
    public BedRenderTypes renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;

    public ImageBedBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.IMAGE_BED_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = DyeColor.WHITE;
        this.imageLocation = "picaxe:blocks/bed";
        this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
    }

    public ImageBedBlockEntity(BlockPos blockPos, BlockState blockState, DyeColor dyeColor) {
        super((BlockEntityType)ModBlockEntities.IMAGE_BED_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = dyeColor;
        this.imageLocation = "picaxe:blocks/bed";
        this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128359_("imageLocation", this.imageLocation);
        compoundTag.m_128359_("color", this.color.m_41065_());
        if (this.renderTypes != null) {
            compoundTag.m_128359_("renderTypes", this.renderTypes.name());
        } else {
            compoundTag.m_128359_("renderTypes", BedRenderTypes.DRAPE_SIDES_FULL.name());
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.imageLocation = compoundTag.m_128461_("imageLocation");
        if (!compoundTag.m_128441_("imageLocation")) {
            this.imageLocation = "picaxe:blocks/bed";
        }
        this.color = DyeColor.m_41057_((String)compoundTag.m_128461_("color"), (DyeColor)DyeColor.WHITE);
        if (compoundTag.m_128441_("renderTypes")) {
            try {
                this.renderTypes = BedRenderTypes.valueOf(compoundTag.m_128461_("renderTypes"));
            }
            catch (IllegalArgumentException e) {
                this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
            }
        } else {
            this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public BedRenderTypes getRenderTypes() {
        return this.renderTypes;
    }

    public void setColor(DyeColor dyeColor) {
        this.color = dyeColor;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setRenderTypes(BedRenderTypes renderTypes) {
        this.renderTypes = renderTypes;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void setImageLocation(String url) {
        this.imageLocation = url;
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void loadFromItemStack(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            if (tag.m_128441_("imageLocation")) {
                this.imageLocation = tag.m_128461_("imageLocation");
            }
            if (tag.m_128441_("color")) {
                this.color = DyeColor.m_41057_((String)tag.m_128461_("color"), (DyeColor)DyeColor.WHITE);
            }
            if (tag.m_128441_("renderTypes")) {
                try {
                    this.renderTypes = BedRenderTypes.valueOf(tag.m_128461_("renderTypes"));
                }
                catch (IllegalArgumentException e) {
                    this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
                }
            }
        } else {
            this.imageLocation = "picaxe:blocks/bed";
            this.color = DyeColor.WHITE;
            this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
        }
    }
}

