/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.entities;

import java.net.URI;
import java.net.URISyntaxException;
import net.jacobwasbeast.picaxe.ModBlockEntities;
import net.jacobwasbeast.picaxe.api.BannerRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ImageWallBannerBlockEntity
extends BlockEntity {
    public DyeColor color;
    private String imageLocation;
    public BannerRenderTypes renderTypes = BannerRenderTypes.OVER_BANNER;

    public ImageWallBannerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.IMAGE_WALL_BANNER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = DyeColor.WHITE;
        this.imageLocation = "picaxe:blocks/banner";
    }

    public ImageWallBannerBlockEntity(BlockPos blockPos, BlockState blockState, DyeColor dyeColor) {
        super((BlockEntityType)ModBlockEntities.IMAGE_WALL_BANNER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = dyeColor;
        this.imageLocation = "picaxe:blocks/banner";
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public BannerRenderTypes getRenderTypes() {
        return this.renderTypes;
    }

    public void setColor(DyeColor dyeColor) {
        this.color = dyeColor;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setRenderTypes(BannerRenderTypes renderTypes) {
        this.renderTypes = renderTypes;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setImageLocation(String url) {
        URI uri;
        try {
            String encodedUrl = url.replace(" ", "%20");
            uri = new URI(encodedUrl);
            if (!uri.isAbsolute() || uri.getScheme() == null || uri.getHost() == null) {
                throw new URISyntaxException(url, "URL is not absolute");
            }
        }
        catch (URISyntaxException e) {
            if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
                Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237115_((String)"picaxe.errors.invalid_url_format"));
            }
            return;
        }
        String path = uri.getPath();
        if (path == null || !path.toLowerCase().endsWith(".png") && !path.toLowerCase().endsWith(".jpg") && !path.toLowerCase().endsWith(".jpeg")) {
            if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
                Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237115_((String)"picaxe.errors.invalid_image_extension"));
            }
            return;
        }
        this.imageLocation = uri.toString();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128359_("imageLocation", this.imageLocation);
        compoundTag.m_128359_("color", this.color.m_41065_());
        compoundTag.m_128359_("id", "picaxe:image_banner");
        if (this.renderTypes != null) {
            compoundTag.m_128359_("renderTypes", this.renderTypes.name());
        } else {
            compoundTag.m_128359_("renderTypes", BannerRenderTypes.OVER_BANNER.name());
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.imageLocation = compoundTag.m_128461_("imageLocation");
        if (!compoundTag.m_128441_("imageLocation")) {
            this.imageLocation = "picaxe:blocks/banner";
        }
        this.color = DyeColor.m_41057_((String)compoundTag.m_128461_("color"), (DyeColor)DyeColor.WHITE);
        if (compoundTag.m_128441_("renderTypes")) {
            try {
                this.renderTypes = BannerRenderTypes.valueOf(compoundTag.m_128461_("renderTypes"));
            }
            catch (IllegalArgumentException e) {
                this.renderTypes = BannerRenderTypes.OVER_BANNER;
            }
        } else {
            this.renderTypes = BannerRenderTypes.OVER_BANNER;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

