/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.forge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ImageShieldItemRendererForge
extends BlockEntityWithoutLevelRenderer {
    private static final Material SHIELD_BASE = new Material(Sheets.f_110738_, ResourceLocation.withDefaultNamespace((String)"entity/shield_base"));
    private static final Material SHIELD_BASE_NOPATTEN = new Material(Sheets.f_110738_, ResourceLocation.withDefaultNamespace((String)"entity/shield_base_nopattern"));
    @Nullable
    private ModelPart plate;
    @Nullable
    private ModelPart handle;

    public ImageShieldItemRendererForge() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    private void initializeModels() {
        if (this.plate == null || this.handle == null) {
            EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
            ModelPart shieldModel = modelSet.m_171103_(ModelLayers.f_171179_);
            this.plate = shieldModel.m_171324_("plate");
            this.handle = shieldModel.m_171324_("handle");
        }
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        String imageUrl;
        boolean isBlocking;
        this.initializeModels();
        if (this.plate == null || this.handle == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        boolean isGUI = displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.FIXED;
        Material baseMaterial = isGUI ? SHIELD_BASE : SHIELD_BASE_NOPATTEN;
        VertexConsumer baseConsumer = baseMaterial.m_119194_(buffer, RenderType::m_110446_);
        boolean bl = isBlocking = Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6117_() && Minecraft.m_91087_().f_91074_.m_21211_() == stack;
        if (isBlocking) {
            switch (displayContext) {
                case FIRST_PERSON_RIGHT_HAND: 
                case FIRST_PERSON_LEFT_HAND: {
                    poseStack.m_85837_(0.0, 0.1, -0.4);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(10.0f));
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    poseStack.m_85837_(0.4, -0.1, 0.0);
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(-20.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(20.0f));
                    break;
                }
                case THIRD_PERSON_LEFT_HAND: {
                    poseStack.m_85837_(-0.4, -0.1, 0.0);
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(-20.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(-20.0f));
                    break;
                }
            }
        }
        this.handle.m_104301_(poseStack, baseConsumer, packedLight, packedOverlay);
        this.plate.m_104301_(poseStack, baseConsumer, packedLight, packedOverlay);
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && !(imageUrl = tag.m_128461_("imageLocation")).isBlank()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            poseStack.m_85837_(-0.5, (double)-0.88f, -0.5);
            ImageUtils.renderImageFromURL(poseStack, buffer, packedLight, packedOverlay, 0.0f, 0.63f, 1.25f, imageUrl);
        }
        poseStack.m_85849_();
    }
}

