/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.items;

import java.util.List;
import net.jacobwasbeast.picaxe.ModBlocks;
import net.jacobwasbeast.picaxe.ModCreativeTabs;
import net.jacobwasbeast.picaxe.api.BannerRenderTypes;
import net.jacobwasbeast.picaxe.api.BedRenderTypes;
import net.jacobwasbeast.picaxe.blocks.ImageBannerBlock;
import net.jacobwasbeast.picaxe.blocks.ImageBedBlock;
import net.jacobwasbeast.picaxe.blocks.ImageFrameBlock;
import net.jacobwasbeast.picaxe.blocks.ImageWallBannerBlock;
import net.jacobwasbeast.picaxe.blocks.SixSidedImageBlock;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBannerBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBedBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.ImageWallBannerBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.jacobwasbeast.picaxe.utils.ClientUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PicAxeItem
extends AxeItem {
    public static final String DEFAULT_URL = "picaxe:blocks/bed";
    private static final String URL_KEY = "image_url";

    public PicAxeItem() {
        super((Tier)Tiers.IRON, 6.0f, -3.1f, new Item.Properties().m_41487_(1).m_41503_(100).arch$tab(ModCreativeTabs.PICAXE_TAB));
    }

    public static void setURL(ItemStack stack, String url) {
        if (stack.m_41720_() instanceof PicAxeItem) {
            stack.m_41784_().m_128359_(URL_KEY, url);
        }
    }

    public static String getURL(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(URL_KEY)) {
            return stack.m_41783_().m_128461_(URL_KEY);
        }
        return DEFAULT_URL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_ && player.m_6047_()) {
            ClientUtils.OpenURLInputScreen(player, hand);
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Player player = useOnContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.m_6047_()) {
            return InteractionResult.PASS;
        }
        Level level = useOnContext.m_43725_();
        BlockPos clickedPos = useOnContext.m_8083_();
        BlockState blockState = level.m_8055_(clickedPos);
        Block block = blockState.m_60734_();
        ItemStack heldStack = useOnContext.m_43722_();
        if (block instanceof SixSidedImageBlock) {
            if (player.m_36335_().m_41519_((Item)this)) {
                return InteractionResult.FAIL;
            }
            player.m_36335_().m_41524_((Item)this, 20);
            BlockEntity blockEntity = level.m_7702_(clickedPos);
            if (blockEntity instanceof SixSidedImageBlockEntity) {
                SixSidedImageBlockEntity imageBlockEntity = (SixSidedImageBlockEntity)blockEntity;
                Direction face = useOnContext.m_43719_();
                String imageUrl = PicAxeItem.getURL(heldStack);
                imageBlockEntity.setImageUrl(face, imageUrl);
                if (imageUrl.isEmpty()) {
                    player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_block.remove_face", (Object[])new Object[]{face.m_122433_()}), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_block.set_face", (Object[])new Object[]{face.m_122433_(), imageUrl}), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (block instanceof ImageFrameBlock) {
            BlockEntity face;
            if (level.f_46443_ && (face = level.m_7702_(clickedPos)) instanceof ImageFrameBlockEntity) {
                ImageFrameBlockEntity imageFrameEntity = (ImageFrameBlockEntity)face;
                imageFrameEntity.setConfiguration(imageFrameEntity.getImageUrl(), imageFrameEntity.getFrameWidth(), imageFrameEntity.getFrameHeight(), imageFrameEntity.shouldStretchToFit(), imageFrameEntity.getAlignment(), imageFrameEntity.getOffsetX(), imageFrameEntity.getOffsetY(), imageFrameEntity.getOffsetZ());
                ClientUtils.OpenImageFrameConfig(player, imageFrameEntity);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (block instanceof BedBlock) {
            if (player.m_36335_().m_41519_((Item)this)) {
                return InteractionResult.FAIL;
            }
            player.m_36335_().m_41524_((Item)this, 20);
            if (block instanceof ImageBedBlock) {
                BlockPos headPos = blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT ? clickedPos.m_121945_((Direction)blockState.m_61143_((Property)BedBlock.f_54117_)) : clickedPos;
                Object imageUrl = level.m_7702_(headPos);
                if (imageUrl instanceof ImageBedBlockEntity) {
                    ImageBedBlockEntity imageBedEntity = (ImageBedBlockEntity)((Object)imageUrl);
                    imageUrl = PicAxeItem.getURL(heldStack);
                    if (imageBedEntity.getImageLocation().equals(imageUrl)) {
                        int max = BedRenderTypes.values().length;
                        int currentIndex = imageBedEntity.getRenderTypes().ordinal();
                        int nextIndex = (currentIndex + 1) % max;
                        imageBedEntity.setRenderTypes(BedRenderTypes.values()[nextIndex]);
                        player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_bed.render_type", (Object[])new Object[]{imageBedEntity.getRenderTypes().name().toLowerCase()}), true);
                    } else {
                        imageBedEntity.setImageLocation((String)imageUrl);
                        player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_bed.set", (Object[])new Object[]{imageUrl}), true);
                    }
                }
            } else {
                this.updateBedEntity(blockState, clickedPos, level, heldStack);
                player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_bed.set", (Object[])new Object[]{PicAxeItem.getURL(heldStack)}), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (block instanceof AbstractBannerBlock) {
            if (player.m_36335_().m_41519_((Item)this)) {
                return InteractionResult.FAIL;
            }
            player.m_36335_().m_41524_((Item)this, 20);
            if (block instanceof ImageBannerBlock || block instanceof ImageWallBannerBlock) {
                int nextIndex;
                int currentIndex;
                int max;
                Object imageUrl;
                BlockEntity imageBannerEntity;
                BlockEntity imageBedEntity = level.m_7702_(clickedPos);
                if (imageBedEntity instanceof ImageBannerBlockEntity) {
                    imageBannerEntity = (ImageBannerBlockEntity)imageBedEntity;
                    imageUrl = PicAxeItem.getURL(heldStack);
                    if (imageBannerEntity.getImageLocation().equals(imageUrl)) {
                        max = BannerRenderTypes.values().length;
                        if (max > 0) {
                            currentIndex = imageBannerEntity.getRenderTypes().ordinal();
                            nextIndex = (currentIndex + 1) % max;
                            imageBannerEntity.setRenderTypes(BannerRenderTypes.values()[nextIndex]);
                            player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_banner.render_type", (Object[])new Object[]{imageBannerEntity.getRenderTypes().name().toLowerCase()}), true);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"picaxe.image_banner.already_set"), true);
                        }
                    } else {
                        imageBannerEntity.setImageLocation((String)imageUrl);
                        player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_banner.set", (Object[])new Object[]{imageUrl}), true);
                    }
                }
                if ((imageUrl = level.m_7702_(clickedPos)) instanceof ImageWallBannerBlockEntity) {
                    imageBannerEntity = (ImageWallBannerBlockEntity)((Object)imageUrl);
                    imageUrl = PicAxeItem.getURL(heldStack);
                    if (imageBannerEntity.getImageLocation().equals(imageUrl)) {
                        max = BannerRenderTypes.values().length;
                        if (max > 0) {
                            currentIndex = imageBannerEntity.getRenderTypes().ordinal();
                            nextIndex = (currentIndex + 1) % max;
                            imageBannerEntity.setRenderTypes(BannerRenderTypes.values()[nextIndex]);
                            player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_banner.render_type", (Object[])new Object[]{imageBannerEntity.getRenderTypes().name().toLowerCase()}), true);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"picaxe.image_banner.already_set"), true);
                        }
                    } else {
                        imageBannerEntity.setImageLocation((String)imageUrl);
                        player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_banner.set", (Object[])new Object[]{imageUrl}), true);
                    }
                }
            } else {
                this.updateBannerEntity(blockState, clickedPos, level, heldStack);
                player.m_5661_((Component)Component.m_237110_((String)"picaxe.image_banner.set", (Object[])new Object[]{PicAxeItem.getURL(heldStack)}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(useOnContext);
    }

    public void updateBedEntity(BlockState blockState, BlockPos clickedPos, Level level, ItemStack stack) {
        BlockPos headPosForColor = blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD ? clickedPos : clickedPos.m_121945_((Direction)blockState.m_61143_((Property)BedBlock.f_54117_));
        DyeColor color = DyeColor.WHITE;
        BlockEntity blockEntity = level.m_7702_(headPosForColor);
        if (blockEntity instanceof BedBlockEntity) {
            BedBlockEntity bedEntity = (BedBlockEntity)blockEntity;
            color = bedEntity.m_58731_();
        }
        Direction facing = (Direction)blockState.m_61143_((Property)BedBlock.f_54117_);
        BedPart part = (BedPart)blockState.m_61143_((Property)BedBlock.f_49440_);
        BlockPos otherPartPos = part == BedPart.HEAD ? clickedPos.m_121945_(facing.m_122424_()) : clickedPos.m_121945_(facing);
        ImageBedBlock imageBed = (ImageBedBlock)((Object)ModBlocks.IMAGE_BED_BLOCK.get());
        BlockState newFoot = (BlockState)((BlockState)imageBed.m_49966_().m_61124_((Property)BedBlock.f_54117_, (Comparable)facing)).m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT);
        BlockState newHead = (BlockState)((BlockState)imageBed.m_49966_().m_61124_((Property)BedBlock.f_54117_, (Comparable)facing)).m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
        BlockPos headPos = part == BedPart.HEAD ? clickedPos : otherPartPos;
        BlockPos footPos = part == BedPart.FOOT ? clickedPos : otherPartPos;
        level.m_7731_(footPos, Blocks.f_50016_.m_49966_(), 18);
        level.m_7731_(headPos, Blocks.f_50016_.m_49966_(), 18);
        level.m_7731_(footPos, newFoot, 3);
        level.m_7731_(headPos, newHead, 3);
        BlockEntity blockEntity2 = level.m_7702_(headPos);
        if (blockEntity2 instanceof ImageBedBlockEntity) {
            ImageBedBlockEntity imageBedEntity = (ImageBedBlockEntity)blockEntity2;
            imageBedEntity.setColor(color);
            imageBedEntity.setImageLocation(PicAxeItem.getURL(stack));
        }
    }

    public void updateBannerEntity(BlockState blockState, BlockPos clickedPos, Level level, ItemStack stack) {
        BlockEntity imageBannerEntity;
        BlockState newState;
        if (level.m_5776_()) {
            return;
        }
        Block block = blockState.m_60734_();
        if (!(block instanceof BannerBlock) && !(block instanceof WallBannerBlock)) {
            return;
        }
        DyeColor color = block instanceof WallBannerBlock ? ((WallBannerBlock)block).m_48674_() : (block instanceof BannerBlock ? ((BannerBlock)block).m_48674_() : DyeColor.WHITE);
        if (block instanceof WallBannerBlock) {
            Block newBlock = (Block)ModBlocks.IMAGE_WALL_BANNER_BLOCK.get();
            newState = (BlockState)newBlock.m_49966_().m_61124_((Property)WallBannerBlock.f_57916_, (Comparable)((Direction)blockState.m_61143_((Property)WallBannerBlock.f_57916_)));
        } else {
            Block newBlock = (Block)ModBlocks.IMAGE_BANNER_BLOCK.get();
            newState = (BlockState)newBlock.m_49966_().m_61124_((Property)BannerBlock.f_49007_, (Comparable)((Integer)blockState.m_61143_((Property)BannerBlock.f_49007_)));
        }
        level.m_7731_(clickedPos, newState, 3);
        BlockEntity blockEntity = level.m_7702_(clickedPos);
        if (blockEntity instanceof ImageBannerBlockEntity) {
            imageBannerEntity = (ImageBannerBlockEntity)blockEntity;
            imageBannerEntity.setColor(color);
            imageBannerEntity.setImageLocation(PicAxeItem.getURL(stack));
        }
        if ((blockEntity = level.m_7702_(clickedPos)) instanceof ImageWallBannerBlockEntity) {
            imageBannerEntity = (ImageWallBannerBlockEntity)blockEntity;
            imageBannerEntity.setColor(color);
            imageBannerEntity.setImageLocation(PicAxeItem.getURL(stack));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237113_((String)"URL: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)PicAxeItem.getURL(stack)).m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.picaxe.when_used").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.picaxe.use_action").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.picaxe.sneak_use_action").m_130940_(ChatFormatting.YELLOW));
    }
}

