/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.ReactorBluePrintItemPacket;
import net.nuclearteam.createnuclear.content.multiblock.controller.EventTriggerPacket;

public enum CNPackets {
    CONFIGURE_REACTOR_PATTERN(ReactorBluePrintItemPacket.class, ReactorBluePrintItemPacket::new, NetworkDirection.PLAY_TO_SERVER),
    TRIGGER_EVENT_TEXT_OVERLAY(EventTriggerPacket.class, EventTriggerPacket::new, NetworkDirection.PLAY_TO_CLIENT);

    public static final ResourceLocation CHANNEL_NAME;
    public static final int NETWORK_VERSION = 0;
    public static final String NETWORK_VERSION_STR;
    private static SimpleChannel channel;
    private final PacketType<?> packetType;

    private <T extends SimplePacketBase> CNPackets(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
        this.packetType = new PacketType<T>(type, factory, direction);
    }

    public static void registerPackets() {
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_NAME).serverAcceptedVersions(NETWORK_VERSION_STR::equals).clientAcceptedVersions(NETWORK_VERSION_STR::equals).networkProtocolVersion(() -> NETWORK_VERSION_STR).simpleChannel();
        for (CNPackets packet : CNPackets.values()) {
            packet.packetType.register();
        }
    }

    public static SimpleChannel getChannel() {
        return channel;
    }

    public static void sendToNear(Level world, BlockPos pos, int range, Object message) {
        CNPackets.getChannel().send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)range, (ResourceKey)world.m_46472_())), message);
    }

    static {
        CHANNEL_NAME = CreateNuclear.asResource("main");
        NETWORK_VERSION_STR = String.valueOf(0);
    }

    private static class PacketType<T extends SimplePacketBase> {
        private static int index = 0;
        private final BiConsumer<T, FriendlyByteBuf> encoder = SimplePacketBase::write;
        private final Function<FriendlyByteBuf, T> decoder;
        private final BiConsumer<T, Supplier<NetworkEvent.Context>> handler;
        private final Class<T> type;
        private final NetworkDirection direction;

        private PacketType(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
            this.decoder = factory;
            this.handler = (packet, contextSupplier) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                if (packet.handle(context)) {
                    context.setPacketHandled(true);
                }
            };
            this.type = type;
            this.direction = direction;
        }

        private void register() {
            CNPackets.getChannel().messageBuilder(this.type, index++, this.direction).encoder(this.encoder).decoder(this.decoder).consumerNetworkThread(this.handler).add();
        }
    }
}

