/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.enriching.campfire;

import com.simibubi.create.foundation.block.IBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nuclearteam.createnuclear.CNBlockEntityTypes;
import net.nuclearteam.createnuclear.CNEffects;
import net.nuclearteam.createnuclear.content.enriching.campfire.EnrichingCampfireBlockEntity;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnrichingCampfireBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
IBE<EnrichingCampfireBlockEntity> {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final boolean spawnParticles;

    public EnrichingCampfireBlock(BlockBehaviour.Properties property, boolean spawnParticles, int fireDamage) {
        super(property);
        this.spawnParticles = spawnParticles;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)CNEffects.RADIATION.get(), 100, 0));
        }
        super.m_7892_(state, level, pos, entity);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelAccessor = context.m_43725_();
        boolean bl = levelAccessor.m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!bl))).m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        if (random.m_188503_(10) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
        }
        if (this.spawnParticles && random.m_188503_(5) == 0) {
            for (int i = 0; i < random.m_188503_(1) + 1; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.m_188501_() / 2.0f), 5.0E-5, (double)(random.m_188501_() / 2.0f));
            }
        }
    }

    public static void dowse(@Nullable Entity entity, LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            for (int i = 0; i < 20; ++i) {
                EnrichingCampfireBlock.makeParticles((Level)level, pos);
            }
        }
        if ((blockEntity = level.m_7702_(pos)) instanceof EnrichingCampfireBlockEntity) {
            ((EnrichingCampfireBlockEntity)blockEntity).dowse();
        }
        level.m_142346_(entity, GameEvent.f_157792_, pos);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            boolean bl = (Boolean)state.m_61143_((Property)LIT);
            if (bl) {
                if (!level.m_5776_()) {
                    level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                EnrichingCampfireBlock.dowse(null, level, pos, state);
            }
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            level.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)level));
            return true;
        }
        return false;
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockPos = hit.m_82425_();
        if (!level.f_46443_ && projectile.m_6060_() && projectile.m_142265_(level, blockPos) && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        }
    }

    public static void makeParticles(Level level, BlockPos pos) {
        RandomSource randomSource = level.m_213780_();
        level.m_6485_((ParticleOptions)ParticleTypes.f_123777_, true, (double)pos.m_123341_() + 0.5 + randomSource.m_188500_() / 3.0 * (double)(randomSource.m_188499_() ? 1 : -1), (double)pos.m_123342_() + randomSource.m_188500_() + randomSource.m_188500_(), (double)pos.m_123343_() + 0.5 + randomSource.m_188500_() / 3.0 * (double)(randomSource.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, WATERLOGGED, FACING});
    }

    public Class<EnrichingCampfireBlockEntity> getBlockEntityClass() {
        return EnrichingCampfireBlockEntity.class;
    }

    public BlockEntityType<? extends EnrichingCampfireBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CNBlockEntityTypes.ENRICHING_CAMPFIRE_BLOCK.get();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnrichingCampfireBlockEntity((BlockEntityType)CNBlockEntityTypes.ENRICHING_CAMPFIRE_BLOCK.get(), pos, state);
    }

    public <S extends BlockEntity> BlockEntityTicker<S> m_142354_(Level level, BlockState state, BlockEntityType<S> blockEntityType) {
        if (level.f_46443_ && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return EnrichingCampfireBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)CNBlockEntityTypes.ENRICHING_CAMPFIRE_BLOCK.get()), EnrichingCampfireBlockEntity::particleTick);
        }
        return null;
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    public static int getLight(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }
}

