/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.output;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nuclearteam.createnuclear.CNBlockEntityTypes;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNShapes;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlockEntity;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutputEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorOutput
extends DirectionalKineticBlock
implements IWrenchable,
IBE<ReactorOutputEntity> {
    public static final IntegerProperty DIR = IntegerProperty.m_61631_((String)"dir", (int)0, (int)2);

    public ReactorOutput(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIR});
        super.m_7926_(builder);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ReactorControllerBlock controller = this.FindController(pos, level, level.m_6907_(), false);
        if (controller != null) {
            ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)controller.getBlockEntity((BlockGetter)level, pos.m_6630_(3));
            assert (entity != null);
            if (entity.getAssembled()) {
                ReactorOutputEntity control = Objects.requireNonNull((ReactorOutputEntity)this.getBlockEntity((BlockGetter)level, pos));
                if (control.getDir() == 0) {
                    control.setDir(1, level, pos);
                } else {
                    control.setDir(0, level, pos);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        List players = level.m_6907_();
        this.FindController(pos, level, players, true);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        List players = level.m_6907_();
        this.FindController(pos, level, players, false);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        List players = pLevel.m_6907_();
        this.FindController(pPos, pLevel, players, false);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CNShapes.REACTOR_OUTPUT.get((Direction)state.m_61143_((Property)FACING));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (context.m_43723_() != null && context.m_43723_().m_6144_() || preferred == null) {
            return super.m_5573_(context);
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)preferred)).m_61124_((Property)DIR, (Comparable)Integer.valueOf(0));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.m_61143_((Property)FACING);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public boolean hideStressImpact() {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public Class<ReactorOutputEntity> getBlockEntityClass() {
        return ReactorOutputEntity.class;
    }

    public BlockEntityType<? extends ReactorOutputEntity> getBlockEntityType() {
        return (BlockEntityType)CNBlockEntityTypes.REACTOR_OUTPUT.get();
    }

    public ReactorControllerBlock FindController(BlockPos blockPos, Level level, List<? extends Player> players, boolean first) {
        Vec3i pos = new Vec3i(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        BlockPos newBlock = new BlockPos(pos.m_123341_(), pos.m_123342_() + 3, pos.m_123343_());
        if (level.m_8055_(newBlock).m_60713_((Block)CNBlocks.REACTOR_CONTROLLER.get())) {
            ReactorControllerBlock controller = (ReactorControllerBlock)level.m_8055_(newBlock).m_60734_();
            controller.Verify(level.m_8055_(newBlock), newBlock, level, players, first);
            ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)controller.getBlockEntity((BlockGetter)level, newBlock);
            if (entity.created) {
                return controller;
            }
        }
        return null;
    }
}

