/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbattery;

import com.hlysine.create_connected.content.kineticbattery.KineticBatteryBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class KineticBatteryValueBox
extends ValueBoxTransform.Sided {
    private final double offset;

    public KineticBatteryValueBox(double offset) {
        this.offset = offset;
    }

    protected boolean isSideActive(BlockState state, Direction side) {
        Direction batteryFacing = (Direction)state.m_61143_((Property)KineticBatteryBlock.FACING);
        return batteryFacing.m_122434_() != side.m_122434_();
    }

    public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
        Direction side = this.getSide();
        Direction batteryFacing = (Direction)state.m_61143_((Property)KineticBatteryBlock.FACING);
        float roll = 0.0f;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(batteryFacing) != side) continue;
            roll = p.getXRotation();
        }
        if (batteryFacing == Direction.UP) {
            roll += 180.0f;
        }
        float horizontalAngle = AngleHelper.horizontalAngle((Direction)batteryFacing);
        float verticalAngle = AngleHelper.verticalAngle((Direction)batteryFacing);
        Vec3 local = VecHelper.voxelSpace((double)8.0, (double)15.5, (double)this.offset);
        local = VecHelper.rotateCentered((Vec3)local, (double)roll, (Direction.Axis)Direction.Axis.Z);
        local = VecHelper.rotateCentered((Vec3)local, (double)horizontalAngle, (Direction.Axis)Direction.Axis.Y);
        local = VecHelper.rotateCentered((Vec3)local, (double)verticalAngle, (Direction.Axis)Direction.Axis.X);
        return local;
    }

    public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
        Direction facing = (Direction)state.m_61143_((Property)KineticBatteryBlock.FACING);
        if (facing.m_122434_() == Direction.Axis.Y) {
            super.rotate(level, pos, state, ms);
            return;
        }
        float roll = 0.0f;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(facing) != this.getSide()) continue;
            roll = p.getXRotation();
        }
        float yRot = AngleHelper.horizontalAngle((Direction)facing) + (float)(facing == Direction.DOWN ? 180 : 0);
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(facing == Direction.DOWN ? -90.0f : 90.0f)).rotateYDegrees(roll);
    }

    protected Vec3 getSouthLocation() {
        return Vec3.f_82478_;
    }
}

