/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.chestedcompanions.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import me.khajiitos.chestedcompanions.common.ChestedCompanions;
import me.khajiitos.chestedcompanions.common.config.CCConfigValues;
import me.khajiitos.chestedcompanions.common.util.InventoryCapacity;

public class CCConfig {
    private static final File file = new File("config/chestedcompanions.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @Entry
    public static final CCConfigValues.BooleanValue allowChestOnCats = new CCConfigValues.BooleanValue(true);
    @Entry
    public static final CCConfigValues.BooleanValue allowChestOnWolves = new CCConfigValues.BooleanValue(true);
    @Entry
    public static final CCConfigValues.BooleanValue invertShiftToOpen = new CCConfigValues.BooleanValue(false);
    @Entry
    public static final CCConfigValues.BooleanValue publicChest = new CCConfigValues.BooleanValue(false);
    @Entry
    public static final CCConfigValues.EnumValue<InventoryCapacity> catInventoryCapacity = new CCConfigValues.EnumValue<InventoryCapacity>(InventoryCapacity.ONE_ROW);
    @Entry
    public static final CCConfigValues.EnumValue<InventoryCapacity> wolfInventoryCapacity = new CCConfigValues.EnumValue<InventoryCapacity>(InventoryCapacity.ONE_ROW);
    @Entry(clientOnly=true)
    public static final CCConfigValues.BooleanValue hideCatChest = new CCConfigValues.BooleanValue(false);
    @Entry(clientOnly=true)
    public static final CCConfigValues.BooleanValue hideWolfChest = new CCConfigValues.BooleanValue(false);
    @Entry
    public static final CCConfigValues.BooleanValue allowChestOnBabyCat = new CCConfigValues.BooleanValue(false);
    @Entry
    public static final CCConfigValues.BooleanValue allowChestOnBabyWolf = new CCConfigValues.BooleanValue(false);
    @Entry(clientOnly=true)
    public static final CCConfigValues.BooleanValue showChestIconOnCats = new CCConfigValues.BooleanValue(false);
    @Entry(clientOnly=true)
    public static final CCConfigValues.BooleanValue showChestIconOnWolves = new CCConfigValues.BooleanValue(false);

    public static void init() {
        if (!file.exists()) {
            CCConfig.save();
        } else {
            CCConfig.load();
        }
    }

    public static void save() {
        if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
            ChestedCompanions.LOGGER.error("Failed to create config directory");
            return;
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            JsonObject jsonObject = new JsonObject();
            for (Field field : CCConfig.class.getDeclaredFields()) {
                Object object;
                if (!field.isAnnotationPresent(Entry.class) || !((object = field.get(null)) instanceof CCConfigValues.Value)) continue;
                CCConfigValues.Value configValue = (CCConfigValues.Value)object;
                jsonObject.add(field.getName(), configValue.write());
            }
            GSON.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
        }
        catch (IOException e) {
            ChestedCompanions.LOGGER.error("Failed to save the Chested Companions config", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            ChestedCompanions.LOGGER.error("Error while saving the Chested Companions config", (Throwable)e);
        }
    }

    public static void load() {
        if (!file.exists()) {
            return;
        }
        try (FileReader fileReader = new FileReader(file);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)fileReader, JsonObject.class);
            for (Field field : CCConfig.class.getDeclaredFields()) {
                Object object;
                String fieldName;
                if (!field.isAnnotationPresent(Entry.class) || !jsonObject.has(fieldName = field.getName()) || !((object = field.get(null)) instanceof CCConfigValues.Value)) continue;
                CCConfigValues.Value configValue = (CCConfigValues.Value)object;
                JsonElement jsonElement = jsonObject.get(fieldName);
                configValue.setUnchecked(configValue.read(jsonElement));
            }
        }
        catch (IOException e) {
            ChestedCompanions.LOGGER.error("Failed to read the Chested Companions config", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            ChestedCompanions.LOGGER.error("Error while reading the Chested Companions config", (Throwable)e);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Entry {
        public String category() default "general";

        public boolean clientOnly() default false;
    }
}

