/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.data;

import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import net.minecraft.network.FriendlyByteBuf;

public class ExposureInfo {
    protected final String exposureId;
    protected final int width;
    protected final int height;
    protected final FilmType type;
    protected final boolean wasPrinted;
    protected final boolean isLoadedFromFile;
    protected final long timestampUnixSeconds;

    public ExposureInfo(String exposureId, int width, int height, FilmType type, boolean wasPrinted, boolean isLoadedFromFile, long timestampUnixSeconds) {
        this.exposureId = exposureId;
        this.width = width;
        this.height = height;
        this.type = type;
        this.wasPrinted = wasPrinted;
        this.isLoadedFromFile = isLoadedFromFile;
        this.timestampUnixSeconds = timestampUnixSeconds;
    }

    public static ExposureInfo empty(String exposureId) {
        return new ExposureInfo(exposureId, 0, 0, FilmType.COLOR, false, false, 0L);
    }

    public boolean isEmpty() {
        return this.getWidth() == 0 && this.getHeight() == 0 && this.getTimestampUnixSeconds() == 0L;
    }

    public String getExposureId() {
        return this.exposureId;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public FilmType getType() {
        return this.type;
    }

    public boolean wasPrinted() {
        return this.wasPrinted;
    }

    public boolean isLoadedFromFile() {
        return this.isLoadedFromFile;
    }

    public long getTimestampUnixSeconds() {
        return this.timestampUnixSeconds;
    }

    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.exposureId);
        buffer.writeInt(this.width);
        buffer.writeInt(this.height);
        buffer.m_130068_((Enum)this.type);
        buffer.writeBoolean(this.wasPrinted);
        buffer.writeBoolean(this.isLoadedFromFile);
        buffer.writeLong(this.timestampUnixSeconds);
        return buffer;
    }

    public static ExposureInfo fromBuffer(FriendlyByteBuf buffer) {
        return new ExposureInfo(buffer.m_130277_(), buffer.readInt(), buffer.readInt(), (FilmType)buffer.m_130066_(FilmType.class), buffer.readBoolean(), buffer.readBoolean(), buffer.readLong());
    }
}

