/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.data.server;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure_catalog.data.ExposureInfo;
import io.github.mortuusars.exposure_catalog.data.server.CatalogCache;
import io.github.mortuusars.exposure_catalog.mixin.ServersideExposureStorageAccessor;
import io.github.mortuusars.exposure_catalog.network.Packets;
import io.github.mortuusars.exposure_catalog.network.packet.IPacket;
import io.github.mortuusars.exposure_catalog.network.packet.client.SendExposuresDataPartS2CP;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public class Catalog {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CLEAR_TIME_ACTIVE_MINUTES = 30;
    private static final int CLEAR_TIME_INACTIVE_MINUTES = 0;
    private static final CatalogCache CACHE = new CatalogCache();
    private static final Set<ServerPlayer> watchingPlayers = new HashSet<ServerPlayer>();
    private static long clearTimestamp = Long.MAX_VALUE;

    public static CatalogCache getCache() {
        return CACHE;
    }

    public static void queryExposures(ServerPlayer player, boolean forceRebuild) {
        Runnable onFinished = () -> Catalog.sendToPlayer(player);
        if (forceRebuild) {
            CACHE.rebuild(onFinished);
        } else {
            CACHE.buildIfNeeded(onFinished);
        }
        Catalog.addWatchingPlayer(player);
    }

    public static void sendToPlayer(ServerPlayer player) {
        Catalog.send(packet -> Packets.sendToClient(packet, player));
    }

    public static void send(Consumer<IPacket> sender) {
        List<ExposureInfo> exposures = CACHE.getExposures().values().stream().toList();
        if (exposures.isEmpty()) {
            sender.accept(new SendExposuresDataPartS2CP(0, true, exposures));
        } else {
            List parts = Lists.partition(exposures, (int)2500);
            for (int i = 0; i < parts.size(); ++i) {
                SendExposuresDataPartS2CP packet = new SendExposuresDataPartS2CP(i, i == parts.size() - 1, (List)parts.get(i));
                sender.accept(packet);
            }
        }
    }

    public static void onExposureSaved(String id, ExposureSavedData data) {
        CACHE.addExposure(id, data);
    }

    public static boolean deleteExposure(String exposureId) {
        try {
            Path path = ((ServersideExposureStorageAccessor)ExposureServer.getExposureStorage()).getWorldPathSupplier().get().resolve("data/exposures/" + exposureId + ".dat");
            if (Files.deleteIfExists(path)) {
                LOGGER.info(exposureId + " deleted.");
                CACHE.removeExposure(exposureId);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Deleting exposure failed: " + e);
            return false;
        }
    }

    public static void addWatchingPlayer(ServerPlayer player) {
        watchingPlayers.add(player);
        Catalog.updateClearTime();
    }

    public static void removeWatchingPlayer(ServerPlayer player) {
        watchingPlayers.remove(player);
        Catalog.updateClearTime();
    }

    public static boolean shouldClear() {
        return clearTimestamp <= Util.m_137550_();
    }

    public static void clear() {
        Catalog.getCache().clear();
        clearTimestamp = Long.MAX_VALUE;
        Catalog.send(Packets::sendToAllClients);
    }

    private static void updateClearTime() {
        clearTimestamp = Util.m_137550_() + Duration.ofMinutes(watchingPlayers.isEmpty() ? 0L : 30L).toMillis();
    }
}

