/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.network.handler;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure_catalog.data.client.CatalogClient;
import io.github.mortuusars.exposure_catalog.data.client.CatalogReceiver;
import io.github.mortuusars.exposure_catalog.gui.screen.CatalogScreen;
import io.github.mortuusars.exposure_catalog.network.packet.client.OpenCatalogS2CP;
import io.github.mortuusars.exposure_catalog.network.packet.client.SendExposureThumbnailS2CP;
import io.github.mortuusars.exposure_catalog.network.packet.client.SendExposuresDataPartS2CP;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.slf4j.Logger;

public class ClientPacketsHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    private static void executeOnMainThread(Runnable runnable) {
        Minecraft.m_91087_().execute(runnable);
    }

    public static void openCatalog(OpenCatalogS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> Minecraft.m_91087_().m_91152_((Screen)new CatalogScreen()));
    }

    public static void receiveExposuresPart(SendExposuresDataPartS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> CatalogReceiver.receivePart(packet.exposures(), packet.partIndex(), packet.isLastPart()));
    }

    public static void receiveExposureThumbnail(SendExposureThumbnailS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> CatalogClient.setThumbnail(packet.thumbnail()));
    }
}

