/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.simulate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import mrtjp.fengine.api.ICFlatMap;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICRegister;
import mrtjp.fengine.simulate.ICSimulationCallback;

public class ICSimulation {
    private final ICRegister[] registers;
    private final ICGate[] gates;
    private final int[][] regDependents;
    private final int[][] gateInputs;
    private final int[][] gateOutputs;
    private Queue<Integer> changeQueue = new LinkedList<Integer>();
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public ICSimulation(Map<Integer, ICRegister> registerMap, Map<Integer, ICGate> gateMap, Map<Integer, ArrayList<Integer>> registerDependentsMap, Map<Integer, ArrayList<Integer>> gateInputsMap, Map<Integer, ArrayList<Integer>> gateOutputsMap) {
        int regCount = registerMap.isEmpty() ? 0 : ICSimulation.maxKey(registerMap) + 1;
        int gateCount = gateMap.isEmpty() ? 0 : ICSimulation.maxKey(gateMap) + 1;
        this.registers = ICSimulation.expandIntoArray(registerMap, new ICRegister[regCount]);
        this.gates = ICSimulation.expandIntoArray(gateMap, new ICGate[gateCount]);
        this.regDependents = ICSimulation.expandIntoDoubleIntArray(registerDependentsMap, regCount);
        this.gateInputs = ICSimulation.expandIntoDoubleIntArray(gateInputsMap, gateCount);
        this.gateOutputs = ICSimulation.expandIntoDoubleIntArray(gateOutputsMap, gateCount);
    }

    public ICSimulation(ICFlatMap map) {
        this(map.getRegisters(), map.getGates(), map.getRegDependents(), map.getGateDependencies(), map.getGateDependents());
    }

    private static int maxKey(Map<Integer, ?> map) {
        return map.keySet().stream().mapToInt(c -> c).max().orElse(0);
    }

    private static <T> T[] expandIntoArray(Map<Integer, T> map, T[] array) {
        for (Map.Entry<Integer, T> e : map.entrySet()) {
            array[e.getKey().intValue()] = e.getValue();
        }
        return array;
    }

    private static int[][] expandIntoDoubleIntArray(Map<Integer, ArrayList<Integer>> map, int length) {
        int[][] array = new int[length][];
        Arrays.fill((Object[])array, EMPTY_INT_ARRAY);
        for (Map.Entry<Integer, ArrayList<Integer>> e : map.entrySet()) {
            array[e.getKey().intValue()] = e.getValue().isEmpty() ? EMPTY_INT_ARRAY : e.getValue().stream().mapToInt(c -> c).toArray();
        }
        return array;
    }

    private void runCompute(int gateID) {
        this.gates[gateID].compute(this, this.gateInputs[gateID], this.gateOutputs[gateID]);
    }

    public byte getRegByteVal(int r) {
        return this.registers[r].getByteVal();
    }

    public short getRegShortVal(int r1, int r0) {
        short i = 0;
        i = (short)(i | (short)((this.getRegByteVal(r1) & 0xFF) << 8));
        i = (short)(i | (short)(this.getRegByteVal(r0) & 0xFF));
        return i;
    }

    public int getRegIntVal(int r3, int r2, int r1, int r0) {
        int i = 0;
        i |= (this.getRegByteVal(r3) & 0xFF) << 24;
        i |= (this.getRegByteVal(r2) & 0xFF) << 16;
        i |= (this.getRegByteVal(r1) & 0xFF) << 8;
        return i |= this.getRegByteVal(r0) & 0xFF;
    }

    public long getRegLongVal(int r7, int r6, int r5, int r4, int r3, int r2, int r1, int r0) {
        long i = 0L;
        i |= (long)(this.getRegByteVal(r7) & 0xFF) << 56;
        i |= (long)(this.getRegByteVal(r6) & 0xFF) << 48;
        i |= (long)(this.getRegByteVal(r5) & 0xFF) << 40;
        i |= (long)(this.getRegByteVal(r4) & 0xFF) << 32;
        i |= (long)(this.getRegByteVal(r3) & 0xFF) << 24;
        i |= (long)(this.getRegByteVal(r2) & 0xFF) << 16;
        i |= (long)(this.getRegByteVal(r1) & 0xFF) << 8;
        return i |= (long)(this.getRegByteVal(r0) & 0xFF);
    }

    public short getRegShortVal(int[] regIDs, int offset) {
        short i = 0;
        i = (short)(i | (short)((this.getRegByteVal(regIDs[offset]) & 0xFF) << 8));
        i = (short)(i | (short)(this.getRegByteVal(regIDs[offset + 1]) & 0xFF));
        return i;
    }

    public int getRegIntVal(int[] regIDs, int offset) {
        int i = 0;
        i |= (this.getRegByteVal(regIDs[offset]) & 0xFF) << 24;
        i |= (this.getRegByteVal(regIDs[offset + 1]) & 0xFF) << 16;
        i |= (this.getRegByteVal(regIDs[offset + 2]) & 0xFF) << 8;
        return i |= this.getRegByteVal(regIDs[offset + 3]) & 0xFF;
    }

    public long getRegLongVal(int[] regIDs, int offset) {
        long i = 0L;
        i |= (long)(this.getRegByteVal(regIDs[offset]) & 0xFF) << 56;
        i |= (long)(this.getRegByteVal(regIDs[offset + 1]) & 0xFF) << 48;
        i |= (long)(this.getRegByteVal(regIDs[offset + 2]) & 0xFF) << 40;
        i |= (long)(this.getRegByteVal(regIDs[offset + 3]) & 0xFF) << 32;
        i |= (long)(this.getRegByteVal(regIDs[offset + 4]) & 0xFF) << 24;
        i |= (long)(this.getRegByteVal(regIDs[offset + 5]) & 0xFF) << 16;
        i |= (long)(this.getRegByteVal(regIDs[offset + 6]) & 0xFF) << 8;
        return i |= (long)(this.getRegByteVal(regIDs[offset + 7]) & 0xFF);
    }

    public void queueRegByteVal(int regID, byte newVal) {
        if (this.registers[regID].queueByteVal(newVal)) {
            this.changeQueue.add(regID);
        }
    }

    public void queueRegShortVal(int r1, int r0, short newVal) {
        this.queueRegByteVal(r1, (byte)(newVal >> 8));
        this.queueRegByteVal(r0, (byte)newVal);
    }

    public void queueRegIntVal(int r3, int r2, int r1, int r0, int newVal) {
        this.queueRegByteVal(r3, (byte)(newVal >> 24));
        this.queueRegByteVal(r2, (byte)(newVal >> 16));
        this.queueRegByteVal(r1, (byte)(newVal >> 8));
        this.queueRegByteVal(r0, (byte)newVal);
    }

    public void queueRegLongVal(int r7, int r6, int r5, int r4, int r3, int r2, int r1, int r0, long newVal) {
        this.queueRegByteVal(r7, (byte)(newVal >> 56));
        this.queueRegByteVal(r6, (byte)(newVal >> 48));
        this.queueRegByteVal(r5, (byte)(newVal >> 40));
        this.queueRegByteVal(r4, (byte)(newVal >> 32));
        this.queueRegByteVal(r3, (byte)(newVal >> 24));
        this.queueRegByteVal(r2, (byte)(newVal >> 16));
        this.queueRegByteVal(r1, (byte)(newVal >> 8));
        this.queueRegByteVal(r0, (byte)newVal);
    }

    public void queueRegShortVal(int[] regIDs, int offset, short newVal) {
        this.queueRegByteVal(regIDs[offset], (byte)(newVal >> 8));
        this.queueRegByteVal(regIDs[offset + 1], (byte)newVal);
    }

    public void queueRegIntVal(int[] regIDs, int offset, int newVal) {
        this.queueRegByteVal(regIDs[offset], (byte)(newVal >> 24));
        this.queueRegByteVal(regIDs[offset + 1], (byte)(newVal >> 16));
        this.queueRegByteVal(regIDs[offset + 2], (byte)(newVal >> 8));
        this.queueRegByteVal(regIDs[offset + 3], (byte)newVal);
    }

    public void queueRegLongVal(int[] regIDs, int offset, long newVal) {
        this.queueRegByteVal(regIDs[offset], (byte)(newVal >> 56));
        this.queueRegByteVal(regIDs[offset + 1], (byte)(newVal >> 48));
        this.queueRegByteVal(regIDs[offset + 2], (byte)(newVal >> 40));
        this.queueRegByteVal(regIDs[offset + 3], (byte)(newVal >> 32));
        this.queueRegByteVal(regIDs[offset + 4], (byte)(newVal >> 24));
        this.queueRegByteVal(regIDs[offset + 5], (byte)(newVal >> 16));
        this.queueRegByteVal(regIDs[offset + 6], (byte)(newVal >> 8));
        this.queueRegByteVal(regIDs[offset + 7], (byte)newVal);
    }

    public boolean computeAll(ICSimulationCallback callback) {
        for (int id = 0; id < this.gates.length; ++id) {
            this.runCompute(id);
        }
        this.propagate(callback);
        return this.changeQueue.isEmpty();
    }

    public boolean propagate(ICSimulationCallback callback) {
        int[] allComputes = new int[this.gates.length];
        Arrays.fill(allComputes, 0);
        HashSet<Integer> computes = new HashSet<Integer>();
        boolean hasOverflow = false;
        int overflowGateId = -1;
        HashSet<Integer> allChanges = new HashSet<Integer>();
        Queue<Object> changes = new LinkedList();
        while (!this.changeQueue.isEmpty() && !hasOverflow) {
            int regID;
            allChanges.addAll(this.changeQueue);
            changes = this.changeQueue;
            this.changeQueue = new LinkedList<Integer>();
            Iterator iterator = changes.iterator();
            while (iterator.hasNext()) {
                regID = (Integer)iterator.next();
                this.registers[regID].pushVal(this);
            }
            computes.clear();
            iterator = changes.iterator();
            while (iterator.hasNext()) {
                regID = (Integer)iterator.next();
                for (int gateID : this.regDependents[regID]) {
                    if (computes.contains(gateID)) continue;
                    this.runCompute(gateID);
                    computes.add(gateID);
                }
            }
            iterator = computes.iterator();
            while (iterator.hasNext()) {
                int i;
                int n = i = ((Integer)iterator.next()).intValue();
                allComputes[n] = allComputes[n] + 1;
                if (allComputes[n] <= 32) continue;
                hasOverflow = true;
                overflowGateId = i;
            }
        }
        if (hasOverflow && callback != null) {
            callback.icEventComputeOverflow(new HashSet<Integer>(changes), Collections.singleton(overflowGateId), 32);
        }
        if (!allChanges.isEmpty() && callback != null) {
            callback.registersDidChange(allChanges);
        }
        return !allChanges.isEmpty();
    }
}

