/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.wires;

import mrtjp.fengine.api.PropagationFunction;
import mrtjp.projectred.fabrication.engine.IBundledCableICTile;
import mrtjp.projectred.fabrication.engine.IBundledConnectableICTile;
import mrtjp.projectred.fabrication.engine.ICTileType;
import mrtjp.projectred.fabrication.engine.IConnectableICTile;
import mrtjp.projectred.fabrication.engine.IInsulatedConnectableICTile;
import mrtjp.projectred.fabrication.engine.wires.ICWireTileType;
import mrtjp.projectred.fabrication.engine.wires.WireTile;
import mrtjp.projectred.transmission.WireType;

public class BundledWireTile
extends WireTile
implements IBundledCableICTile {
    public BundledWireTile(int colour) {
        super(colour == -1 ? ICTileType.BUNDLED_NEUTRAL_WIRE : ICWireTileType.BUNDLED_COLOURED[colour].tileType, WireType.values()[WireType.BUNDLED_WHITE.ordinal() + colour]);
    }

    @Override
    public int getBundledColour() {
        return this.getWireType().getColourIdx();
    }

    @Override
    public boolean canConnectTo(IConnectableICTile target, int towardsDir) {
        if (target instanceof IBundledCableICTile) {
            int thisColour;
            int targetColour = ((IBundledCableICTile)((Object)target)).getBundledColour();
            return targetColour == (thisColour = this.getBundledColour()) || targetColour == -1 || thisColour == -1;
        }
        if (target instanceof IInsulatedConnectableICTile) {
            return true;
        }
        return target instanceof IBundledConnectableICTile;
    }

    @Override
    public PropagationFunction propagationFunc(int inDir, int inPort) {
        return (outDir, outPort) -> outPort == inPort && this.maskConnectsToDir(inDir) && this.maskConnectsToDir(outDir);
    }
}

