/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.wires;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.HashSet;
import java.util.Set;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.api.IPathFinderManifest;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.ICTileType;
import mrtjp.projectred.fabrication.engine.IConnectableICTile;
import mrtjp.projectred.fabrication.engine.IRedstoneConnectableICTile;
import mrtjp.projectred.fabrication.engine.log.DeadWireWarning;
import mrtjp.projectred.fabrication.engine.wires.WireTile;
import mrtjp.projectred.transmission.WireType;
import net.minecraft.nbt.CompoundTag;

public abstract class RedstoneWireTile
extends WireTile
implements IRedstoneConnectableICTile {
    private static final int PACKET_SIGNAL = 2;
    protected final Set<Integer> inputRegisters = new HashSet<Integer>();
    protected byte signal = 0;

    public RedstoneWireTile(ICTileType tileType, WireType renderType) {
        super(tileType, renderType);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128344_("signal", this.signal);
        tag.m_128344_("numInputReg", (byte)this.inputRegisters.size());
        int i = 0;
        for (Integer inputReg : this.inputRegisters) {
            tag.m_128405_("inR" + i++, inputReg.intValue());
        }
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.signal = tag.m_128445_("signal");
        int numInputReg = tag.m_128445_("numInputReg") & 0xFF;
        for (int i = 0; i < numInputReg; ++i) {
            this.inputRegisters.add(tag.m_128451_("inR" + i));
        }
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        out.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        this.signal = in.readByte();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 2: {
                this.signal = in.readByte();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendSignalUpdate() {
        this.getWriteStream(2).writeByte((int)this.signal);
    }

    @Override
    public boolean canConnectTo(IConnectableICTile target, int towardsDir) {
        return target instanceof IRedstoneConnectableICTile;
    }

    @Override
    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
        byte oldSignal = this.signal;
        this.signal = 0;
        for (Integer inputReg : this.inputRegisters) {
            boolean isHigh = container.pullRegisterValue(inputReg) > 0;
            this.signal = (byte)(isHigh ? -1 : 0);
            if (!isHigh) continue;
            break;
        }
        if (oldSignal != this.signal) {
            this.sendSignalUpdate();
        }
    }

    @Override
    public void searchManifest(IPathFinderManifest manifest) {
        this.inputRegisters.clear();
        this.inputRegisters.addAll(manifest.getOutputRegisters());
        if (this.inputRegisters.isEmpty()) {
            this.getEditor().getStateMachine().getCompilerLog().addProblem(new DeadWireWarning(this.getPos()));
        }
    }

    @Override
    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        HashSet<Integer> remappedInputs = new HashSet<Integer>();
        for (Integer inputReg : this.inputRegisters) {
            int remapped = remapProvider.getRemappedRegisterID(inputReg);
            remappedInputs.add(remapped);
        }
        this.inputRegisters.clear();
        this.inputRegisters.addAll(remappedInputs);
    }
}

