/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.gui.ICEditorToolManager;
import mrtjp.projectred.fabrication.gui.TabButtonNode;
import mrtjp.projectred.fabrication.gui.TabControllerNode;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchScreen;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;

public class ICEditorToolTab
extends AbstractGuiNode
implements TabControllerNode.IToolbarTab {
    private static final int GROUP_U = 390;
    private static final int GROUP_V = 61;
    private static final int GROUP_WIDTH = 64;
    private static final int GROUP_HEIGHT = 16;
    private static final int FULL_BUTTON_U = 390;
    private static final int FULL_BUTTON_V = 77;
    private static final int FULL_BUTTON_WIDTH = 64;
    private static final int FULL_BUTTON_HEIGHT = 16;
    private static final int SINGLE_BUTTON_U = 454;
    private static final int SINGLE_BUTTON_V = 77;
    private static final int SINGLE_BUTTON_WIDTH = 16;
    private static final int SINGLE_BUTTON_HEIGHT = 16;
    private static final int BUTTON_SELECTED_SHIFT_U = 0;
    private static final int BUTTON_SELECTED_SHIFT_V = 16;
    private static final int BUTTON_MOUSEOVER_SHIFT_U = 0;
    private static final int BUTTON_MOUSEOVER_SHIFT_V = 32;
    protected final ICEditorToolManager manager;
    protected final IICEditorTool tool;
    private int rowIndex = 0;
    private int columnIndex = 0;

    public ICEditorToolTab(ICEditorToolManager manager, IICEditorTool tool) {
        this.manager = manager;
        this.tool = tool;
        this.setSize(84, 222);
    }

    private void setAndIncrGridPos(AbstractGuiNode node, int cellWidth) {
        if (this.columnIndex + cellWidth > 4) {
            this.columnIndex = 0;
            ++this.rowIndex;
        }
        node.setPosition(7 + this.columnIndex * 16, 18 + this.rowIndex * 16);
        this.columnIndex += cellWidth;
        if (this.columnIndex > 4) {
            this.columnIndex = 0;
            ++this.rowIndex;
        }
    }

    protected void addGroup(String unlocal) {
        this.addGroup((Component)Component.m_237115_((String)unlocal));
    }

    protected void addGroup(Component groupName) {
        GroupHeaderNode header = new GroupHeaderNode(groupName);
        this.setAndIncrGridPos(header, 4);
        this.addChild((RedUINode)header);
    }

    protected void addFullRowButton(ButtonController controller) {
        FullRowButtonNode button = new FullRowButtonNode(controller);
        this.setAndIncrGridPos(button, 4);
        this.addChild((RedUINode)button);
    }

    protected void addSingleButton(ButtonController controller) {
        SingleColumnButtonNode button = new SingleColumnButtonNode(controller);
        this.setAndIncrGridPos(button, 1);
        this.addChild((RedUINode)button);
    }

    public IICEditorTool getTool() {
        return this.tool;
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        graphics.m_280163_(ICWorkbenchScreen.BACKGROUND, this.getPosition().x, this.getPosition().y, 305.0f, 0.0f, 84, 222, 512, 512);
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public void onTabClosed() {
        this.setHidden(true);
    }

    @Override
    public void onTabOpened() {
        this.setHidden(false);
        this.manager.swapTools(this.tool.getToolType());
    }

    @Override
    public void onTabMinimized() {
        this.setHidden(true);
    }

    @Override
    public TabButtonNode createButtonNode() {
        return new TabButtonNode(this, TabButtonNode.TabSide.LEFT){

            @Override
            public void renderIcon(GuiGraphics graphics, Point mouse, float partialFrame) {
            }

            @Override
            public void buildTooltip(List<Component> tooltip) {
                tooltip.add((Component)Component.m_237113_((String)"//TODO implement tab"));
            }
        };
    }

    private static class GroupHeaderNode
    extends AbstractGuiNode {
        private final Component title;

        public GroupHeaderNode(Component title) {
            this.title = title;
            this.setSize(64, 16);
        }

        public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
            graphics.m_280163_(ICWorkbenchScreen.BACKGROUND, this.getPosition().x, this.getPosition().y, 390.0f, 61.0f, this.getFrame().width(), this.getFrame().height(), 512, 512);
            Font fontRenderer = this.getRoot().getFontRenderer();
            int n = this.getPosition().x + 2;
            int n2 = this.getPosition().y + 8;
            Objects.requireNonNull(fontRenderer);
            graphics.m_280430_(fontRenderer, this.title, n, n2 - 9 / 2, 0xFFFFFF);
        }
    }

    private static class FullRowButtonNode
    extends AbstractButtonNode {
        public FullRowButtonNode(ButtonController controller) {
            super(controller, 64, 16, new Point(390, 77), new Point(0, 16), new Point(0, 32));
        }
    }

    protected static interface ButtonController {
        public void getTooltip(List<Component> var1);

        public void onClick();

        public boolean isSelected();

        public void renderIcon(GuiGraphics var1, Point var2, float var3);
    }

    private static class SingleColumnButtonNode
    extends AbstractButtonNode {
        public SingleColumnButtonNode(ButtonController controller) {
            super(controller, 16, 16, new Point(454, 77), new Point(0, 16), new Point(0, 32));
        }
    }

    private static class AbstractButtonNode
    extends AbstractGuiNode {
        private final ButtonController controller;
        private final Point uvBg;
        private final Point uvBgSelectedShift;
        private final Point uvMouseOverShift;

        public AbstractButtonNode(ButtonController controller, int width, int height, Point uvBg, Point uvBgSelectedShift, Point uvMouseOverShift) {
            this.controller = controller;
            this.setSize(width, height);
            this.uvBg = uvBg;
            this.uvBgSelectedShift = uvBgSelectedShift;
            this.uvMouseOverShift = uvMouseOverShift;
        }

        public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
            RenderSystem.enableBlend();
            boolean mouseover = this.getFrame().contains(mouse) && this.isFirstHit(mouse);
            boolean selected = this.controller.isSelected();
            int x = this.getPosition().x;
            int y = this.getPosition().y;
            int w = this.getFrame().width();
            int h = this.getFrame().height();
            int uBackground = this.uvBg.x + (selected ? this.uvBgSelectedShift.x : 0);
            int vBackground = this.uvBg.y + (selected ? this.uvBgSelectedShift.y : 0);
            graphics.m_280163_(ICWorkbenchScreen.BACKGROUND, x, y, (float)uBackground, (float)vBackground, w, h, 512, 512);
            if (selected || mouseover) {
                int uMouseOver = this.uvBg.x + this.uvMouseOverShift.x;
                int vMouseOver = this.uvBg.y + this.uvMouseOverShift.y;
                graphics.m_280163_(ICWorkbenchScreen.BACKGROUND, x, y, (float)uMouseOver, (float)vMouseOver, w, h, 512, 512);
            }
            RenderSystem.disableBlend();
            this.controller.renderIcon(graphics, this.getPosition(), partialFrame);
        }

        public void drawFront(GuiGraphics graphics, Point mouse, float partialFrame) {
            if (!this.isFirstHit(mouse)) {
                return;
            }
            LinkedList<Component> tooltip = new LinkedList<Component>();
            this.controller.getTooltip(tooltip);
            this.renderTooltip(graphics, mouse, tooltip);
        }

        public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
            if (!consumed && this.isFirstHit(p)) {
                this.getRoot().getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.controller.onClick();
                return true;
            }
            return false;
        }
    }
}

