/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.impl;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.utils.KeyUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.ButtonWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.ScrollableTextWidget;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Map;

public class ControlsGui
extends ExtendedScreen {
    private final Map<String, KeyUtils.KeyBindData> keyMappings;
    private final KeyUtils instance;
    private final Runnable onKeyChanged;
    private final Map<String, List<String>> categorizedNames = StringUtils.newHashMap();
    private final Map<String, String> categoryNames = StringUtils.newHashMap();
    private String backupKeyString;
    private Tuple<ExtendedButtonControl, ExtendedButtonControl, KeyUtils.KeyBindData> entryData = null;
    private ScrollPane childFrame;

    public ControlsGui(KeyUtils instance, Runnable onKeyChanged, Map<String, KeyUtils.KeyBindData> keyMappings) {
        super("Controls");
        this.instance = instance;
        this.onKeyChanged = onKeyChanged;
        this.keyMappings = keyMappings;
        this.sortMappings();
    }

    public ControlsGui(Runnable onKeyChanged, Map<String, KeyUtils.KeyBindData> keyMappings) {
        this(KeyUtils.INSTANCE, onKeyChanged, keyMappings);
    }

    public ControlsGui(KeyUtils instance, Runnable onKeyChanged, List<String> filterData) {
        this(instance, onKeyChanged, instance.getKeyMappings(filterData));
    }

    public ControlsGui(Runnable onKeyChanged, List<String> filterData) {
        this(KeyUtils.INSTANCE, onKeyChanged, filterData);
    }

    public ControlsGui(KeyUtils instance, Runnable onKeyChanged, String ... filterData) {
        this(instance, onKeyChanged, instance.getKeyMappings(filterData));
    }

    public ControlsGui(Runnable onKeyChanged, String ... filterData) {
        this(KeyUtils.INSTANCE, onKeyChanged, filterData);
    }

    @Override
    public void initializeUi() {
        this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, 180, 20, "Back", () -> {
            if (this.entryData == null) {
                this.openScreen(this.getParent());
            }
        }, new String[0]));
        this.childFrame = this.addControl(new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 64));
        this.setupScreenData();
        super.initializeUi();
    }

    @Override
    public boolean m_7933_(int keyCode, int mouseX, int mouseY) {
        if (this.entryData != null) {
            this.setKeyData(keyCode);
            return true;
        }
        return super.m_7933_(keyCode, mouseX, mouseY);
    }

    private void sortMappings() {
        for (Map.Entry<String, KeyUtils.KeyBindData> entry : this.keyMappings.entrySet()) {
            String keyName = entry.getKey();
            KeyUtils.KeyBindData keyData = entry.getValue();
            String keyCategory = keyData.category();
            if (!this.categorizedNames.containsKey(keyCategory)) {
                this.categorizedNames.put(keyCategory, StringUtils.newArrayList(keyName));
            } else if (!this.categorizedNames.get(keyCategory).contains(keyName)) {
                this.categorizedNames.get(keyCategory).add(keyName);
            }
            if (this.categoryNames.containsKey(keyCategory)) continue;
            this.categoryNames.put(keyCategory, keyData.categoryName());
        }
    }

    private void setupScreenData() {
        this.clearEntryData();
        int currentAllocatedRow = 0;
        for (Map.Entry<String, List<String>> entry : this.categorizedNames.entrySet()) {
            this.childFrame.addWidget(new ScrollableTextWidget(true, 0, this.getButtonY(currentAllocatedRow), this.childFrame.getScreenWidth(), this.categoryNames.get(entry.getKey())));
            ++currentAllocatedRow;
            int middle = this.childFrame.getScreenWidth() / 2 + 3;
            for (String keyName : entry.getValue()) {
                KeyUtils.KeyBindData keyData = this.keyMappings.get(keyName);
                String keyTitle = keyData.displayName();
                int keyCode = this.instance.keySyncQueue.getOrDefault(keyName, keyData.keyCode());
                ButtonWidget keyCodeWidget = new ButtonWidget(this.getButtonY(currentAllocatedRow), 95, 20, this.instance.getKeyName(keyCode), keyTitle, () -> {
                    String details = keyData.details();
                    if (!StringUtils.isNullOrEmpty(details)) {
                        this.drawMultiLineString(StringUtils.splitTextByNewLine(details));
                    }
                }, keyName);
                ExtendedButtonControl keyResetButton = new ExtendedButtonControl(middle + keyCodeWidget.getControlWidth() + 15, this.getButtonY(currentAllocatedRow), 70, 20, "Reset", new String[0]);
                keyResetButton.setOnClick(() -> this.resetEntryData(keyCodeWidget, keyResetButton, keyData));
                keyCodeWidget.setOnClick(() -> this.setupEntryData(keyCodeWidget, keyResetButton, keyData));
                keyResetButton.setControlEnabled(keyCode != keyData.defaultKeyCode());
                this.childFrame.addControl(keyCodeWidget);
                this.childFrame.addControl(keyResetButton);
                ++currentAllocatedRow;
            }
        }
    }

    private void setupEntryData(ExtendedButtonControl button, ExtendedButtonControl resetButton, KeyUtils.KeyBindData keyData) {
        if (this.entryData == null && button.getOptionalArgs() != null) {
            this.entryData = new Tuple<ExtendedButtonControl, ExtendedButtonControl, KeyUtils.KeyBindData>(button, resetButton, keyData);
            this.backupKeyString = button.getControlMessage();
            button.setControlMessage("gui.config.message.editor.enter_key");
        }
    }

    private void resetEntryData(ExtendedButtonControl button, ExtendedButtonControl resetButton, KeyUtils.KeyBindData keyData) {
        if (this.entryData == null && button.getOptionalArgs() != null) {
            this.entryData = new Tuple<ExtendedButtonControl, ExtendedButtonControl, KeyUtils.KeyBindData>(button, resetButton, keyData);
            this.setKeyData(keyData.defaultKeyCode());
        }
    }

    private void setKeyData(int keyCode) {
        int keyToSubmit = keyCode;
        if (!this.instance.isValidKeyCode(keyToSubmit) || this.instance.isValidClearCode(keyToSubmit)) {
            keyToSubmit = ControlsGui.getKeyByVersion(0, -1);
        }
        String formattedKey = this.instance.getKeyName(keyToSubmit);
        String internalName = this.entryData.getFirst().getOptionalArgs()[0];
        try {
            this.entryData.getThird().configEvent().accept(keyToSubmit, false);
            this.instance.keySyncQueue.put(internalName, keyToSubmit);
            if (this.onKeyChanged != null) {
                this.onKeyChanged.run();
            }
            this.entryData.getFirst().setControlMessage(formattedKey);
        }
        catch (Throwable ex) {
            this.entryData.getFirst().setControlMessage(this.backupKeyString);
            CoreUtils.LOG.debugError(ex);
        }
        this.entryData.getSecond().setControlEnabled(keyToSubmit != this.entryData.getThird().defaultKeyCode());
        this.clearEntryData();
    }

    private void clearEntryData() {
        this.backupKeyString = null;
        this.entryData = null;
    }
}

