/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities;

import dev.architectury.injectables.annotations.PlatformOnly;
import earth.terrarium.adastra.common.blockentities.base.TickableBlockEntity;
import earth.terrarium.adastra.common.blocks.SlidingDoorBlock;
import earth.terrarium.adastra.common.registry.ModBlockEntityTypes;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SlidingDoorBlockEntity
extends BlockEntity
implements TickableBlockEntity {
    private int slideTicks;
    private int lastSlideTicks;

    public SlidingDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.SLIDING_DOOR.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.slideTicks = tag.m_128451_("SlideTicks");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SlideTicks", this.slideTicks);
    }

    public int slideTicks() {
        return this.slideTicks;
    }

    public int lastSlideTicks() {
        return this.lastSlideTicks;
    }

    @Override
    public void tick(Level level, long time, BlockState state, BlockPos pos) {
        boolean isOpen = (Boolean)this.m_58900_().m_61143_((Property)SlidingDoorBlock.OPEN) != false || (Boolean)this.m_58900_().m_61143_((Property)SlidingDoorBlock.POWERED) != false;
        this.lastSlideTicks = this.slideTicks;
        if (!level.m_5776_()) {
            if (!isOpen && this.slideTicks == 97) {
                level.m_5594_(null, this.f_58858_, (SoundEvent)ModSoundEvents.SLIDING_DOOR_CLOSE.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
            } else if (isOpen && this.slideTicks == 3) {
                level.m_5594_(null, this.f_58858_, (SoundEvent)ModSoundEvents.SLIDING_DOOR_OPEN.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
            }
        }
        this.slideTicks = Mth.m_14045_((int)(this.slideTicks + (isOpen ? 3 : -3)), (int)0, (int)100);
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(3.0);
    }
}

