/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.util;

import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.fr.FrenchAnalyzer;
import guideme.internal.shaded.lucene.analysis.util.ElisionFilter;
import guideme.internal.shaded.lucene.util.ResourceLoader;
import guideme.internal.shaded.lucene.util.ResourceLoaderAware;
import java.io.IOException;
import java.util.Map;

public class ElisionFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "elision";
    private final String articlesFile;
    private final boolean ignoreCase;
    private CharArraySet articles;

    public ElisionFilterFactory(Map<String, String> args) {
        super(args);
        this.articlesFile = this.get(args, "articles");
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public ElisionFilterFactory() {
        throw ElisionFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.articles = this.articlesFile == null ? FrenchAnalyzer.DEFAULT_ARTICLES : this.getWordSet(loader, this.articlesFile, this.ignoreCase);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ElisionFilter(input, this.articles);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return this.create(input);
    }
}

