/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet;

import guideme.internal.shaded.lucene.facet.FacetsConfig;
import guideme.internal.shaded.lucene.search.TermInSetQuery;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.util.ArrayList;
import java.util.Collection;

public class MultiFacetQuery
extends TermInSetQuery {
    public MultiFacetQuery(FacetsConfig facetsConfig, String dimension, String[] ... paths) {
        super(facetsConfig.getDimConfig((String)dimension).indexFieldName, MultiFacetQuery.toTerms(dimension, paths));
    }

    public MultiFacetQuery(String dimension, String[] ... paths) {
        super(FacetsConfig.DEFAULT_DIM_CONFIG.indexFieldName, MultiFacetQuery.toTerms(dimension, paths));
    }

    static Collection<BytesRef> toTerms(String dimension, String[] ... paths) {
        ArrayList<BytesRef> terms = new ArrayList<BytesRef>(paths.length);
        for (String[] path : paths) {
            terms.add(new BytesRef(FacetsConfig.pathToString(dimension, path)));
        }
        return terms;
    }
}

