/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemRepository;
import com.jaquadro.minecraft.storagedrawers.capabilities.PlatformDrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import com.texelsaurus.minecraft.chameleon.capabilities.ForgeCapability;
import com.texelsaurus.minecraft.chameleon.capabilities.IForgeCapability;
import com.texelsaurus.minecraft.chameleon.service.ForgeCapabilities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.items.IItemHandler;

public class PlatformCapabilities {
    static final Capability<IItemHandler> NATIVE_FORGE_ITEM_HANDLER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    static final Capability<IDrawerAttributes> NATIVE_DRAWER_ATTRIBUTES = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerAttributes>(){});
    static final Capability<IDrawerGroup> NATIVE_DRAWER_GROUP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerGroup>(){});
    static final Capability<IItemRepository> NATIVE_ITEM_REPOSITORY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemRepository>(){});
    static final Capability<com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemHandler> NATIVE_ITEM_HANDLER = CapabilityManager.get((CapabilityToken)new CapabilityToken<com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemHandler>(){});
    public static final ForgeCapability<IDrawerAttributes> DRAWER_ATTRIBUTES = new ForgeCapability<IDrawerAttributes>(Capabilities.DRAWER_ATTRIBUTES.id(), NATIVE_DRAWER_ATTRIBUTES);
    public static final ForgeCapability<IDrawerGroup> DRAWER_GROUP = new ForgeCapability<IDrawerGroup>(Capabilities.DRAWER_GROUP.id(), NATIVE_DRAWER_GROUP);
    public static final ForgeCapability<IItemRepository> ITEM_REPOSITORY = new ForgeCapability<IItemRepository>(Capabilities.ITEM_REPOSITORY.id(), NATIVE_ITEM_REPOSITORY);
    public static final ForgeCapability<com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemHandler> ITEM_HANDLER = new ForgeCapability<com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemHandler>(Capabilities.ITEM_HANDLER.id(), NATIVE_ITEM_HANDLER);
    private static Map<Capability, ForgeCapability> nativeMap = new HashMap<Capability, ForgeCapability>();

    static <T> IForgeCapability<T> cast(ChameleonCapability<T> cap) {
        return (IForgeCapability)cap;
    }

    public static <T> boolean hasCapability(Capability<T> capability) {
        return nativeMap.containsKey(capability);
    }

    public static <T> T getCapability(Capability<T> capability, BlockEntity blockEntity) {
        if (!nativeMap.containsKey(capability)) {
            return null;
        }
        ForgeCapability cap = nativeMap.get(capability);
        return cap.getCapability(blockEntity);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(IDrawerAttributes.class);
        event.register(IDrawerGroup.class);
        event.register(IItemRepository.class);
        event.register(com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemHandler.class);
        nativeMap.put(NATIVE_DRAWER_ATTRIBUTES, DRAWER_ATTRIBUTES);
        nativeMap.put(NATIVE_DRAWER_GROUP, DRAWER_GROUP);
        nativeMap.put(NATIVE_ITEM_REPOSITORY, ITEM_REPOSITORY);
        nativeMap.put(NATIVE_ITEM_HANDLER, ITEM_HANDLER);
        nativeMap.put(NATIVE_FORGE_ITEM_HANDLER, ITEM_HANDLER);
    }

    public static void initHandlers() {
        ForgeCapabilities.reigsterCapability(DRAWER_ATTRIBUTES);
        ForgeCapabilities.reigsterCapability(DRAWER_GROUP);
        ForgeCapabilities.reigsterCapability(ITEM_REPOSITORY);
        ForgeCapabilities.reigsterCapability(ITEM_HANDLER);
        ModBlockEntities.getDrawerTypes().forEach(entity -> {
            PlatformCapabilities.cast(Capabilities.DRAWER_ATTRIBUTES).register(entity, e -> BlockEntityDrawers.getDrawerAttributes(e));
            PlatformCapabilities.cast(Capabilities.DRAWER_GROUP).register(entity, e -> BlockEntityDrawers.getGroup(e));
            PlatformCapabilities.cast(Capabilities.ITEM_REPOSITORY).register(entity, DrawerItemRepository::new);
            PlatformCapabilities.cast(Capabilities.ITEM_HANDLER).register(entity, DrawerItemHandler::new);
            PlatformCapabilities.cast(ITEM_HANDLER).register(entity, PlatformDrawerItemHandler::new);
        });
        PlatformCapabilities.cast(Capabilities.DRAWER_GROUP).register((BlockEntityType)ModBlockEntities.CONTROLLER.get(), e -> e);
        PlatformCapabilities.cast(Capabilities.ITEM_REPOSITORY).register((BlockEntityType)ModBlockEntities.CONTROLLER.get(), BlockEntityController::getItemRepository);
        PlatformCapabilities.cast(Capabilities.ITEM_HANDLER).register((BlockEntityType)ModBlockEntities.CONTROLLER.get(), DrawerItemHandler::new);
        PlatformCapabilities.cast(ITEM_HANDLER).register((BlockEntityType)ModBlockEntities.CONTROLLER.get(), PlatformDrawerItemHandler::new);
        PlatformCapabilities.cast(Capabilities.DRAWER_GROUP).register((BlockEntityType)ModBlockEntities.CONTROLLER_IO.get(), e -> e);
        PlatformCapabilities.cast(Capabilities.ITEM_REPOSITORY).register((BlockEntityType)ModBlockEntities.CONTROLLER_IO.get(), BlockEntitySlave::getItemRepository);
        PlatformCapabilities.cast(Capabilities.ITEM_HANDLER).register((BlockEntityType)ModBlockEntities.CONTROLLER_IO.get(), DrawerItemHandler::new);
        PlatformCapabilities.cast(ITEM_HANDLER).register((BlockEntityType)ModBlockEntities.CONTROLLER_IO.get(), PlatformDrawerItemHandler::new);
    }
}

