/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client;

import li.cil.oc2.client.gui.ComputerContainerScreen;
import li.cil.oc2.client.gui.ComputerTerminalScreen;
import li.cil.oc2.client.gui.KeyboardScreen;
import li.cil.oc2.client.gui.MonitorDisplayScreen;
import li.cil.oc2.client.gui.NetworkTunnelScreen;
import li.cil.oc2.client.gui.RobotContainerScreen;
import li.cil.oc2.client.gui.RobotTerminalScreen;
import li.cil.oc2.client.item.CustomItemColors;
import li.cil.oc2.client.item.CustomItemModelProperties;
import li.cil.oc2.client.model.BusCableModelLoader;
import li.cil.oc2.client.renderer.BusInterfaceNameRenderer;
import li.cil.oc2.client.renderer.ProjectorDepthRenderer;
import li.cil.oc2.client.renderer.blockentity.ChargerRenderer;
import li.cil.oc2.client.renderer.blockentity.ComputerRenderer;
import li.cil.oc2.client.renderer.blockentity.DiskDriveRenderer;
import li.cil.oc2.client.renderer.blockentity.InternetGateWayRenderer;
import li.cil.oc2.client.renderer.blockentity.MonitorRenderer;
import li.cil.oc2.client.renderer.blockentity.ProjectorRenderer;
import li.cil.oc2.client.renderer.color.BusCableBlockColor;
import li.cil.oc2.client.renderer.entity.RobotRenderer;
import li.cil.oc2.client.renderer.entity.model.RobotModel;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.container.Containers;
import li.cil.oc2.common.entity.Entities;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.Nullable;

public final class ClientSetup {
    @Nullable
    private static Boolean captureInputState = null;

    @SubscribeEvent
    public static void handleSetupEvent(FMLClientSetupEvent event) {
        BusInterfaceNameRenderer.initialize();
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.COMPUTER.get()), ComputerRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.MONITOR.get()), MonitorRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.DISK_DRIVE.get()), DiskDriveRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.CHARGER.get()), ChargerRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.PROJECTOR.get()), ProjectorRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntities.INTERNET_GATEWAY.get()), InternetGateWayRenderer::new);
        event.enqueueWork(() -> {
            CustomItemModelProperties.initialize();
            CustomItemColors.initialize();
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.COMPUTER.get()), ComputerContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.COMPUTER_TERMINAL.get()), ComputerTerminalScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.MONITOR.get()), MonitorDisplayScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.ROBOT.get()), RobotContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.ROBOT_TERMINAL.get()), RobotTerminalScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Containers.NETWORK_TUNNEL.get()), NetworkTunnelScreen::new);
            MinecraftForge.EVENT_BUS.register(ProjectorDepthRenderer.class);
        });
    }

    @SubscribeEvent
    public static void handleModelRegistryEvent(ModelEvent.RegisterGeometryLoaders event) {
        if (Blocks.BUS_CABLE.getId() == null) {
            throw new RuntimeException("Null bus cable ID");
        }
        event.register(Blocks.BUS_CABLE.getId().toString().replace("oc2r:", ""), (IGeometryLoader)new BusCableModelLoader());
    }

    @SubscribeEvent
    public void renderHotbar(RenderGuiOverlayEvent event) {
        if (event.getOverlay().id() == VanillaGuiOverlay.HOTBAR.id() && KeyboardScreen.hideHotbar) {
            event.setCanceled(true);
        } else if (event.getOverlay().id() == VanillaGuiOverlay.HOTBAR.id()) {
            event.setCanceled(false);
        }
    }

    @SubscribeEvent
    public static void handleColorHandler(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)new BusCableBlockColor(), new Block[]{(Block)Blocks.BUS_CABLE.get()});
    }

    @SubscribeEvent
    public static void handleEntityRendererRegisterEvent(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)Entities.ROBOT.get(), RobotRenderer::new);
    }

    @SubscribeEvent
    public static void handleRegisterLayerDefinitionsEvent(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RobotModel.ROBOT_MODEL_LAYER, RobotModel::createRobotLayer);
    }

    public static boolean getCaptureInputState() {
        if (captureInputState == null) {
            captureInputState = Config.captureInputDefaultState;
        }
        return captureInputState;
    }

    public static void setCaptureInputState(boolean value) {
        captureInputState = value;
    }
}

