/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Arrays;
import java.util.List;
import li.cil.oc2.client.gui.AbstractModContainerScreen;
import li.cil.oc2.client.gui.MonitorDisplayWidget;
import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.client.gui.widget.ToggleImageButton;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.container.AbstractMonitorContainer;
import li.cil.oc2.common.util.TextFormatUtils;
import li.cil.oc2.common.util.TooltipUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractMonitorDisplayScreen<T extends AbstractMonitorContainer>
extends AbstractModContainerScreen<T> {
    private static final int CONTROLS_TOP = 8;
    private static final int ENERGY_TOP = 8 + Sprites.MONITOR_SIDEBAR_1.height + 4;
    private final MonitorDisplayWidget monitorDisplayWidget = new MonitorDisplayWidget(this);

    protected AbstractMonitorDisplayScreen(T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.f_97726_ = Sprites.MONITOR_SCREEN.width;
        this.f_97727_ = Sprites.MONITOR_SCREEN.height;
    }

    public void m_181908_() {
        super.m_181908_();
        this.monitorDisplayWidget.tick();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.monitorDisplayWidget.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(input)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.monitorDisplayWidget.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(input)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7856_() {
        super.m_7856_();
        this.monitorDisplayWidget.init();
        EditBox focusIndicatorEditBox = new EditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237119_());
        focusIndicatorEditBox.m_93692_(true);
        this.setFocusIndicatorEditBox(focusIndicatorEditBox);
        (this.m_142416_((GuiEventListener)new ToggleImageButton(this.f_97735_ - Sprites.MONITOR_SIDEBAR_1.width + 4, this.f_97736_ + 8 + 4, 12, 12, Sprites.POWER_BUTTON_BASE, Sprites.POWER_BUTTON_PRESSED, Sprites.POWER_BUTTON_ACTIVE){

            protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            }

            @Override
            public void m_5691_() {
                super.m_5691_();
                ((AbstractMonitorContainer)AbstractMonitorDisplayScreen.this.f_97732_).sendPowerStateToServer(!((AbstractMonitorContainer)AbstractMonitorDisplayScreen.this.f_97732_).getPowerState());
            }

            @Override
            public boolean isToggled() {
                return ((AbstractMonitorContainer)AbstractMonitorDisplayScreen.this.f_97732_).getPowerState();
            }
        })).withTooltip(new Component[]{Component.m_237115_((String)Constants.COMPUTER_SCREEN_POWER_CAPTION), Component.m_237115_((String)Constants.COMPUTER_SCREEN_POWER_DESCRIPTION)});
        (this.m_142416_((GuiEventListener)new ToggleImageButton(this.f_97735_ - Sprites.MONITOR_SIDEBAR_1.width + 4, this.f_97736_ + 8 + 4 + 14, 12, 12, Sprites.INPUT_BUTTON_BASE, Sprites.INPUT_BUTTON_PRESSED, Sprites.INPUT_BUTTON_ACTIVE){

            protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            }

            @Override
            public void m_5691_() {
                super.m_5691_();
                ((AbstractMonitorContainer)AbstractMonitorDisplayScreen.this.m_6262_()).toggleCaptureInputState();
            }

            @Override
            public boolean isToggled() {
                return ((AbstractMonitorContainer)AbstractMonitorDisplayScreen.this.m_6262_()).getCaptureInputState();
            }
        })).withTooltip(new Component[]{Component.m_237115_((String)Constants.TERMINAL_CAPTURE_INPUT_CAPTION), Component.m_237115_((String)Constants.TERMINAL_CAPTURE_INPUT_DESCRIPTION)});
    }

    public void m_7379_() {
        super.m_7379_();
        this.monitorDisplayWidget.onClose();
    }

    protected abstract void setFocusIndicatorEditBox(EditBox var1);

    @Override
    protected void renderFg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderFg(graphics, partialTicks, mouseX, mouseY);
        if (this.shouldRenderEnergyBar()) {
            int x = this.f_97735_ - Sprites.SIDEBAR_2.width + 4;
            int y = this.f_97736_ + ENERGY_TOP + 4;
            Sprites.ENERGY_BAR.drawFillY(graphics, x, y, (float)((AbstractMonitorContainer)this.f_97732_).getEnergy() / (float)((AbstractMonitorContainer)this.f_97732_).getEnergyCapacity());
        }
        this.monitorDisplayWidget.render(graphics, (Component)Component.m_237115_((String)Constants.COMPUTER_ERROR_NOT_ENOUGH_ENERGY));
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        Sprites.MONITOR_SIDEBAR_1.draw(graphics, this.f_97735_ - Sprites.MONITOR_SIDEBAR_1.width, this.f_97736_ + 8);
        if (this.shouldRenderEnergyBar()) {
            int x = this.f_97735_ - Sprites.SIDEBAR_2.width;
            int y = this.f_97736_ + ENERGY_TOP;
            Sprites.SIDEBAR_2.draw(graphics, x, y);
            Sprites.ENERGY_BASE.draw(graphics, x + 4, y + 4);
        }
        this.monitorDisplayWidget.renderBackground(graphics, mouseX, mouseY);
    }

    @Override
    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        if (this.shouldRenderEnergyBar() && this.isMouseOver(mouseX, mouseY, -Sprites.SIDEBAR_2.width + 4, ENERGY_TOP + 4, Sprites.ENERGY_BAR.width, Sprites.ENERGY_BAR.height)) {
            List<MutableComponent> tooltip = Arrays.asList(Component.m_237110_((String)Constants.TOOLTIP_ENERGY, (Object[])new Object[]{TextFormatUtils.withFormat(((AbstractMonitorContainer)this.f_97732_).getEnergy() + "/" + ((AbstractMonitorContainer)this.f_97732_).getEnergyCapacity(), ChatFormatting.GREEN)}), Component.m_237110_((String)Constants.TOOLTIP_ENERGY_CONSUMPTION, (Object[])new Object[]{TextFormatUtils.withFormat(String.valueOf(Config.monitorEnergyPerTick), ChatFormatting.GREEN)}));
            TooltipUtils.drawTooltip(graphics, tooltip, mouseX, mouseY, 200);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    private boolean shouldRenderEnergyBar() {
        return ((AbstractMonitorContainer)this.f_97732_).getEnergyCapacity() > 0;
    }
}

