/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.util.Collection;
import java.util.HashSet;
import li.cil.oc2.api.bus.BlockDeviceBusElement;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.util.ChunkLocation;
import li.cil.oc2.common.util.ChunkUtils;
import li.cil.oc2.common.util.ServerScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class BlockDeviceBusController
extends CommonDeviceBusController {
    private final Runnable onBusChunkLoadedStateChanged = this::scheduleBusScan;
    private final HashSet<ChunkLocation> busChunks = new HashSet();
    private final HashSet<ChunkLocation> trackedChunks = new HashSet();
    private final BlockEntity blockEntity;

    public BlockDeviceBusController(DeviceBusElement root, int baseEnergyConsumption, BlockEntity blockEntity) {
        super(root, baseEnergyConsumption);
        this.blockEntity = blockEntity;
    }

    @Override
    public void setDeviceContainersChanged() {
        super.setDeviceContainersChanged();
        for (ChunkLocation location : this.busChunks) {
            location.tryGetLevel().ifPresent(level -> ChunkUtils.setLazyUnsaved(level, location.position()));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeListeners(this.trackedChunks);
        this.trackedChunks.clear();
        this.busChunks.clear();
    }

    @Override
    protected void onAfterBusScan() {
        super.onAfterBusScan();
        Level level = this.blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        this.busChunks.clear();
        HashSet<ChunkLocation> newTrackedChunks = new HashSet<ChunkLocation>();
        for (DeviceBusElement element : this.getElements()) {
            if (!(element instanceof BlockDeviceBusElement)) continue;
            BlockDeviceBusElement blockElement = (BlockDeviceBusElement)element;
            LevelAccessor elementLevel = blockElement.getLevel();
            BlockPos elementPosition = blockElement.getPosition();
            if (elementLevel == null) continue;
            ChunkLocation elementLocation = ChunkLocation.of(elementLevel, elementPosition);
            this.busChunks.add(elementLocation);
            newTrackedChunks.add(elementLocation);
            newTrackedChunks.add(ChunkLocation.of(elementLevel, elementPosition.m_121945_(Direction.NORTH)));
            newTrackedChunks.add(ChunkLocation.of(elementLevel, elementPosition.m_121945_(Direction.EAST)));
            newTrackedChunks.add(ChunkLocation.of(elementLevel, elementPosition.m_121945_(Direction.SOUTH)));
            newTrackedChunks.add(ChunkLocation.of(elementLevel, elementPosition.m_121945_(Direction.WEST)));
        }
        ChunkLocation controllerChunkLocation = ChunkLocation.of((LevelAccessor)level, this.blockEntity.m_58899_());
        this.busChunks.remove(controllerChunkLocation);
        newTrackedChunks.remove(controllerChunkLocation);
        HashSet<ChunkLocation> removedChunks = new HashSet<ChunkLocation>(this.trackedChunks);
        removedChunks.removeAll(newTrackedChunks);
        this.removeListeners(removedChunks);
        HashSet<ChunkLocation> addedChunks = new HashSet<ChunkLocation>(newTrackedChunks);
        newTrackedChunks.removeAll(this.trackedChunks);
        this.addListeners(addedChunks);
        this.trackedChunks.removeAll(removedChunks);
        this.trackedChunks.addAll(newTrackedChunks);
    }

    private void addListeners(Collection<ChunkLocation> trackedChunks) {
        for (ChunkLocation trackedChunk : trackedChunks) {
            trackedChunk.tryGetLevel().ifPresent(level -> {
                ServerScheduler.subscribeOnLoad(level, trackedChunk.position(), this.onBusChunkLoadedStateChanged);
                ServerScheduler.subscribeOnUnload(level, trackedChunk.position(), this.onBusChunkLoadedStateChanged);
            });
        }
    }

    private void removeListeners(Collection<ChunkLocation> trackedChunks) {
        for (ChunkLocation trackedChunk : trackedChunks) {
            trackedChunk.tryGetLevel().ifPresent(level -> {
                ServerScheduler.unsubscribeOnLoad(level, trackedChunk.position(), this.onBusChunkLoadedStateChanged);
                ServerScheduler.unsubscribeOnUnload(level, trackedChunk.position(), this.onBusChunkLoadedStateChanged);
            });
        }
    }
}

