/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.vm.item;

import com.google.common.eventbus.Subscribe;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.data.Firmware;
import li.cil.oc2.api.bus.device.vm.FirmwareLoader;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.api.bus.device.vm.event.VMInitializationException;
import li.cil.oc2.api.bus.device.vm.event.VMInitializingEvent;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.device.util.IdentityProxy;
import li.cil.sedna.api.memory.MemoryMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public final class FirmwareFlashStorageDevice
extends IdentityProxy<ItemStack>
implements VMDevice,
ItemDevice,
FirmwareLoader {
    private final Firmware firmware;
    private MemoryMap memoryMap;

    public FirmwareFlashStorageDevice(ItemStack identity, Firmware firmware) {
        super(identity);
        this.firmware = firmware;
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        this.memoryMap = context.getMemoryMap();
        context.getEventBus().register(this);
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.memoryMap = null;
    }

    @Subscribe
    public void handleInitializingEvent(VMInitializingEvent event) {
        this.copyDataToMemory(event.programStartAddress());
    }

    private void copyDataToMemory(long address) {
        if (!this.firmware.run(this.memoryMap, address)) {
            throw new VMInitializationException((Component)Component.m_237115_((String)Constants.COMPUTER_ERROR_INSUFFICIENT_MEMORY));
        }
    }
}

