/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.entity.robot;

import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2.common.entity.Entities;
import li.cil.oc2.common.entity.Robot;
import li.cil.oc2.common.entity.robot.AbstractRobotAction;
import li.cil.oc2.common.entity.robot.MovementDirection;
import li.cil.oc2.common.entity.robot.RobotActionResult;
import li.cil.oc2.common.entity.robot.RobotActions;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.TickUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec3;

public final class RobotMovementAction
extends AbstractRobotAction {
    public static final double TARGET_EPSILON = 1.0E-4;
    private static final float MOVEMENT_SPEED = 1.0f / (float)TickUtils.toTicks(Duration.ofSeconds(1L));
    private static final String DIRECTION_TAG_NAME = "direction";
    private static final String ORIGIN_TAG_NAME = "origin";
    private static final String START_TAG_NAME = "start";
    private static final String TARGET_TAG_NAME = "target";
    @Nullable
    private MovementDirection direction;
    @Nullable
    private BlockPos origin;
    @Nullable
    private BlockPos start;
    @Nullable
    private BlockPos target;
    @Nullable
    private Vec3 targetPos;

    public RobotMovementAction(MovementDirection direction) {
        super(RobotActions.MOVEMENT);
        this.direction = direction.resolve();
    }

    RobotMovementAction(CompoundTag tag) {
        super(RobotActions.MOVEMENT, tag);
    }

    public static Vec3 getTargetPositionInBlock(BlockPos position) {
        return Vec3.m_82539_((Vec3i)position).m_82520_(0.0, (double)(0.5f * (1.0f - ((EntityType)Entities.ROBOT.get()).m_20679_())), 0.0);
    }

    public static void moveTowards(Robot robot, Vec3 targetPosition) {
        Vec3 delta = targetPosition.m_82546_(robot.m_20182_());
        if (delta.m_82556_() > (double)(MOVEMENT_SPEED * MOVEMENT_SPEED)) {
            delta = delta.m_82541_().m_82490_((double)MOVEMENT_SPEED);
        }
        robot.m_6478_(MoverType.SELF, delta);
    }

    @Override
    public void initialize(Robot robot) {
        if (this.origin == null || this.start == null || this.target == null) {
            this.target = this.start = (this.origin = robot.m_20183_());
            if (this.direction != null) {
                switch (this.direction) {
                    case UPWARD: {
                        this.target = this.target.m_121945_(Direction.UP);
                        break;
                    }
                    case DOWNWARD: {
                        this.target = this.target.m_121945_(Direction.DOWN);
                        break;
                    }
                    case FORWARD: {
                        this.target = this.target.m_121945_(robot.m_6350_());
                        break;
                    }
                    case BACKWARD: {
                        this.target = this.target.m_121945_(robot.m_6350_().m_122424_());
                    }
                }
            }
        }
        this.targetPos = RobotMovementAction.getTargetPositionInBlock(this.target);
        robot.m_20088_().m_135381_(Robot.TARGET_POSITION, (Object)this.target);
    }

    @Override
    public RobotActionResult perform(Robot robot) {
        if (this.targetPos == null) {
            throw new IllegalStateException();
        }
        this.validateTarget(robot);
        this.moveAndResolveCollisions(robot);
        if (robot.m_20182_().m_82557_(this.targetPos) < 1.0E-4) {
            if (Objects.equals(this.target, this.origin)) {
                return RobotActionResult.FAILURE;
            }
            return RobotActionResult.SUCCESS;
        }
        return RobotActionResult.INCOMPLETE;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        NBTUtils.putEnum(tag, DIRECTION_TAG_NAME, this.direction);
        if (this.origin != null) {
            tag.m_128365_(ORIGIN_TAG_NAME, (Tag)NbtUtils.m_129224_((BlockPos)this.origin));
        }
        if (this.start != null) {
            tag.m_128365_(START_TAG_NAME, (Tag)NbtUtils.m_129224_((BlockPos)this.start));
        }
        if (this.target != null) {
            tag.m_128365_(TARGET_TAG_NAME, (Tag)NbtUtils.m_129224_((BlockPos)this.target));
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.direction = NBTUtils.getEnum(tag, DIRECTION_TAG_NAME, MovementDirection.class);
        if (this.direction == null) {
            this.direction = MovementDirection.FORWARD;
        }
        this.direction = this.direction.resolve();
        if (tag.m_128425_(ORIGIN_TAG_NAME, 10)) {
            this.origin = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(ORIGIN_TAG_NAME));
        }
        if (tag.m_128425_(START_TAG_NAME, 10)) {
            this.start = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(START_TAG_NAME));
        }
        if (tag.m_128425_(TARGET_TAG_NAME, 10)) {
            this.target = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(TARGET_TAG_NAME));
            this.targetPos = RobotMovementAction.getTargetPositionInBlock(this.target);
        }
    }

    private void moveAndResolveCollisions(Robot robot) {
        if (this.start == null || this.target == null || this.targetPos == null) {
            return;
        }
        RobotMovementAction.moveTowards(robot, this.targetPos);
        boolean didCollide = robot.f_19862_ || robot.f_19863_;
        long gameTime = robot.m_9236_().m_46467_();
        if (didCollide && !robot.m_9236_().m_5776_() && robot.getLastPistonMovement() < gameTime - 1L) {
            BlockPos newStart = this.target;
            this.target = this.start;
            this.start = newStart;
            this.targetPos = RobotMovementAction.getTargetPositionInBlock(this.target);
            robot.m_20088_().m_135381_(Robot.TARGET_POSITION, (Object)this.target);
        }
    }

    private void validateTarget(Robot robot) {
        int deltaTarget;
        BlockPos currentPosition = robot.m_20183_();
        if (this.start == null || Objects.equals(currentPosition, this.start) || this.target == null || Objects.equals(currentPosition, this.target)) {
            return;
        }
        BlockPos fromStart = currentPosition.m_121996_((Vec3i)this.start);
        BlockPos fromTarget = currentPosition.m_121996_((Vec3i)this.target);
        int deltaStart = fromStart.m_123341_() + fromStart.m_123342_() + fromStart.m_123343_();
        if (deltaStart < (deltaTarget = fromTarget.m_123341_() + fromTarget.m_123342_() + fromTarget.m_123343_())) {
            this.start = currentPosition;
            this.target = this.target.m_121955_((Vec3i)fromStart);
        } else {
            this.start = this.start.m_121955_((Vec3i)fromTarget);
            this.target = currentPosition;
        }
        this.targetPos = RobotMovementAction.getTargetPositionInBlock(this.target);
        robot.m_20088_().m_135381_(Robot.TARGET_POSITION, (Object)this.target);
    }
}

