/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.client.renderer.entity.RobotWithoutLevelRenderer;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.energy.EnergyStorageItemStack;
import li.cil.oc2.common.entity.Entities;
import li.cil.oc2.common.entity.Robot;
import li.cil.oc2.common.entity.robot.RobotActions;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.util.LevelUtils;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.RegistryUtils;
import li.cil.oc2.common.util.TooltipUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class RobotItem
extends ModItem {
    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        TooltipUtils.addEnergyConsumption(Config.robotEnergyPerTick, tooltip);
        TooltipUtils.addEntityEnergyInformation(stack, tooltip);
        TooltipUtils.addEntityInventoryInformation(stack, tooltip);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (Config.robotsUseEnergy()) {
            return new EnergyStorageItemStack(stack, Config.robotEnergyStorage, "oc2r", "energy");
        }
        return null;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        Vec3 position = level.m_8055_(pos = context.m_8083_()).m_60629_(new BlockPlaceContext(context)) ? Vec3.m_82512_((Vec3i)pos) : Vec3.m_82512_((Vec3i)pos.m_121945_(context.m_43719_()));
        Robot robot = (Robot)((EntityType)Entities.ROBOT.get()).m_20615_(context.m_43725_());
        if (robot == null) {
            return InteractionResult.FAIL;
        }
        robot.m_7678_(position.f_82479_, position.f_82480_ - (double)(robot.m_20206_() * 0.5f), position.f_82481_, Direction.m_122364_((double)context.m_7074_()).m_122424_().m_122435_(), 0.0f);
        if (!level.m_45786_((Entity)robot)) {
            return super.m_6225_(context);
        }
        if (!level.m_5776_()) {
            RobotActions.initializeData(robot);
            robot.importFromItemStack(context.m_43722_());
            level.m_7967_((Entity)robot);
            Vec3i posi = new Vec3i((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_);
            LevelUtils.playSound((LevelAccessor)level, new BlockPos(posi), SoundType.f_56743_, SoundType::m_56777_);
            if (context.m_43723_() == null || !context.m_43723_().m_7500_()) {
                context.m_43722_().m_41774_(1);
            }
        }
        if (context.m_43723_() != null) {
            context.m_43723_().m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public boolean m_142095_() {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new RobotWithoutLevelRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
            }
        });
    }

    public static ItemStack getRobotWithFlash() {
        ItemStack robot = new ItemStack((ItemLike)Items.ROBOT.get());
        CompoundTag itemsTag = NBTUtils.getOrCreateChildTag(robot.m_41784_(), "oc2r", "items");
        itemsTag.m_128365_(RegistryUtils.key(DeviceTypes.FLASH_MEMORY), (Tag)NBTUtils.makeInventoryTag(new ItemStack((ItemLike)Items.FLASH_MEMORY_CUSTOM.get())));
        return robot;
    }
}

