/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import java.util.ArrayList;
import li.cil.oc2.common.blockentity.NetworkConnectorBlockEntity;
import li.cil.oc2.common.network.MessageUtils;
import li.cil.oc2.common.network.message.AbstractMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public final class NetworkConnectorConnectionsMessage
extends AbstractMessage {
    private BlockPos pos;
    private ArrayList<BlockPos> connectedPositions;

    public NetworkConnectorConnectionsMessage(NetworkConnectorBlockEntity networkConnector) {
        this.pos = networkConnector.m_58899_();
        this.connectedPositions = new ArrayList<BlockPos>(networkConnector.getConnectedPositions());
    }

    public NetworkConnectorConnectionsMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.connectedPositions = new ArrayList();
        int positionCount = buffer.m_130242_();
        for (int i = 0; i < positionCount; ++i) {
            BlockPos pos = buffer.m_130135_();
            this.connectedPositions.add(pos);
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.connectedPositions.size());
        for (BlockPos pos : this.connectedPositions) {
            buffer.m_130064_(pos);
        }
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        MessageUtils.withClientBlockEntityAt(this.pos, NetworkConnectorBlockEntity.class, networkConnector -> networkConnector.setConnectedPositionsClient(this.connectedPositions));
    }
}

