/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import li.cil.oc2.client.gui.FileChooserScreen;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.AbstractMessage;
import li.cil.oc2.common.network.message.ClientCanceledImportFileMessage;
import li.cil.oc2.common.network.message.ImportedFileMessage;
import li.cil.oc2.common.network.message.MultipartMessage;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RequestImportedFileMessage
extends AbstractMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final MutableComponent FILE_TOO_LARGE_TEXT = TranslationUtils.text("message.{mod}.import_file.file_too_large");
    private int id;

    public RequestImportedFileMessage(int id) {
        this.id = id;
    }

    public RequestImportedFileMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.id = buffer.m_130242_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.id);
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        FileChooserScreen.openFileChooserForLoad(new FileChooserScreen.FileChooserCallback(){

            @Override
            public void onFileSelected(Path path) {
                try {
                    String fileName = path.getFileName().toString();
                    byte[] data = Files.readAllBytes(path);
                    if (data.length > 1048575) {
                        Network.sendToServer(new ClientCanceledImportFileMessage(RequestImportedFileMessage.this.id));
                        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)FILE_TOO_LARGE_TEXT.m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)0xFFA0A0))));
                    } else {
                        MultipartMessage.sendToServer(new ImportedFileMessage(RequestImportedFileMessage.this.id, fileName, data));
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }

            @Override
            public void onCanceled() {
                Network.sendToServer(new ClientCanceledImportFileMessage(RequestImportedFileMessage.this.id));
            }
        });
    }
}

