/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import li.cil.oc2.common.config.AsyncConfig;
import li.cil.oc2.common.util.AsyncUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="oc2r", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class BlobStorage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LevelResource BLOBS_FOLDER_NAME = new LevelResource("oc2r-blobs");
    private static final Map<UUID, FileChannel> BLOBS = new ConcurrentHashMap<UUID, FileChannel>();
    private static final Map<UUID, CompletableFuture<FileChannel>> PENDING_OPERATIONS = new ConcurrentHashMap<UUID, CompletableFuture<FileChannel>>();
    private static volatile Path dataDirectory;

    private static Path getBlobPath(UUID handle) {
        if (dataDirectory == null) {
            throw new IllegalStateException("Data directory not initialized. Server not set?");
        }
        return dataDirectory.resolve(handle.toString());
    }

    public static void setServer(MinecraftServer server) {
        Path newDataDir = server.m_129843_(BLOBS_FOLDER_NAME);
        if (!newDataDir.equals(dataDirectory)) {
            BlobStorage.close();
            dataDirectory = newDataDir;
            try {
                Files.createDirectories(dataDirectory, new FileAttribute[0]);
                LOGGER.info("Blob storage directory initialized at: {}", (Object)dataDirectory);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create blob storage directory", (Throwable)e);
            }
        }
    }

    public static void close() {
        for (CompletableFuture<FileChannel> future : PENDING_OPERATIONS.values()) {
            future.cancel(true);
        }
        PENDING_OPERATIONS.clear();
        for (FileChannel blob : BLOBS.values()) {
            try {
                blob.close();
            }
            catch (IOException e) {
                LOGGER.error("Error closing blob channel", (Throwable)e);
            }
        }
        BLOBS.clear();
        boolean debug = false;
        try {
            debug = AsyncConfig.SERVER != null && (Boolean)AsyncConfig.SERVER.enableSuperDebug.get() != false;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (debug) {
            LOGGER.info("Closed all blob storage resources");
        }
    }

    public static UUID allocateHandle() {
        return UUID.randomUUID();
    }

    public static UUID validateHandle(@Nullable UUID handle) {
        if (handle == null || handle.getMostSignificantBits() == 0L && handle.getLeastSignificantBits() == 0L) {
            return BlobStorage.allocateHandle();
        }
        return handle;
    }

    public static CompletableFuture<FileChannel> getOrOpenAsync(UUID handle) {
        FileChannel existingChannel = BLOBS.get(handle);
        if (existingChannel != null && existingChannel.isOpen()) {
            return CompletableFuture.completedFuture(existingChannel);
        }
        return PENDING_OPERATIONS.computeIfAbsent(handle, h -> AsyncUtils.runAsync(() -> {
            try {
                Path path = dataDirectory.resolve(h.toString());
                FileChannel channel = new RandomAccessFile(path.toFile(), "rw").getChannel();
                BLOBS.put((UUID)h, channel);
                FileChannel fileChannel = channel;
                return fileChannel;
            }
            catch (IOException e) {
                LOGGER.error("Failed to open blob: " + String.valueOf(h), (Throwable)e);
                throw new CompletionException("Failed to open blob: " + String.valueOf(h), e);
            }
            finally {
                PENDING_OPERATIONS.remove(h);
            }
        }, "Open blob " + String.valueOf(h)));
    }

    @Deprecated(since="1.21.1", forRemoval=true)
    public static synchronized FileChannel getOrOpen(UUID handle) throws IOException {
        try {
            return BlobStorage.getOrOpenAsync(handle).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Failed to open blob: " + String.valueOf(handle), e);
        }
    }

    public static CompletableFuture<Void> closeAsync(UUID handle) {
        boolean debug = false;
        try {
            debug = AsyncConfig.SERVER != null && (Boolean)AsyncConfig.SERVER.enableSuperDebug.get() != false;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        boolean finalDebug = debug;
        return AsyncUtils.runAsync(() -> {
            try {
                FileChannel blob = BLOBS.remove(handle);
                if (blob != null) {
                    blob.close();
                    if (finalDebug) {
                        LOGGER.debug("Closed blob: {}", (Object)handle);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Error closing blob: " + String.valueOf(handle), (Throwable)e);
                throw new CompletionException(e);
            }
        }, "Close blob " + String.valueOf(handle));
    }

    @Deprecated(since="1.21.1", forRemoval=true)
    public static synchronized void close(UUID handle) {
        try {
            BlobStorage.closeAsync(handle).join();
        }
        catch (CompletionException e) {
            LOGGER.error("Error in close operation for blob: " + String.valueOf(handle), (Throwable)e);
        }
    }

    public static CompletableFuture<Void> deleteAsync(UUID handle) {
        boolean debug = false;
        try {
            debug = AsyncConfig.SERVER != null && (Boolean)AsyncConfig.SERVER.enableSuperDebug.get() != false;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        boolean finalDebug = debug;
        return AsyncUtils.runAsync(() -> {
            Path path = BlobStorage.getBlobPath(handle);
            try {
                boolean deleted = Files.deleteIfExists(path);
                if (deleted && finalDebug) {
                    LOGGER.debug("Deleted blob file: {}", (Object)path);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error deleting blob file: " + String.valueOf(path), (Throwable)e);
                throw new CompletionException(e);
            }
            return null;
        }, "Deleting blob " + String.valueOf(handle));
    }

    @Deprecated(since="1.21.1", forRemoval=true)
    public static void delete(UUID handle) {
        try {
            BlobStorage.deleteAsync(handle).join();
        }
        catch (CompletionException e) {
            LOGGER.error("Error in delete operation for blob: " + String.valueOf(handle), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void handleServerAboutToStart(ServerAboutToStartEvent event) {
        BlobStorage.setServer(event.getServer());
    }

    @SubscribeEvent
    public static void handleServerStopped(ServerStoppedEvent event) {
        BlobStorage.close();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(BlobStorage::close, "OC2 BlobStorage Shutdown"));
    }
}

