/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.bytes.ByteArrayFIFOQueue;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.oc2.common.vm.terminal.escapes.DECRC;
import li.cil.oc2.common.vm.terminal.escapes.DECSC;
import li.cil.oc2.common.vm.terminal.escapes.HTS;
import li.cil.oc2.common.vm.terminal.escapes.IND;
import li.cil.oc2.common.vm.terminal.escapes.NEL;
import li.cil.oc2.common.vm.terminal.escapes.RI;
import li.cil.oc2.common.vm.terminal.escapes.RIS;
import li.cil.oc2.common.vm.terminal.escapes.apc.APCManager;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSIManager;
import li.cil.oc2.common.vm.terminal.escapes.dcs.DCSManager;
import li.cil.oc2.common.vm.terminal.escapes.osc.OSCManager;
import li.cil.oc2.common.vm.terminal.fonts.FontHandling;
import li.cil.oc2.common.vm.terminal.fonts.Glyph;
import li.cil.oc2.common.vm.terminal.modes.ModeState;
import li.cil.oc2.common.vm.terminal.modes.PrivateModeState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@Serialized
public class Terminal {
    public boolean Use1006 = false;
    public static final int WIDTH = 80;
    public static final int HEIGHT = 24;
    public static final int CHAR_WIDTH = 8;
    public static final int CHAR_HEIGHT = 16;
    public static final int STYLE_BOLD_MASK = 1;
    public static final int STYLE_DIM_MASK = 2;
    public static final int STYLE_UNDERLINE_MASK = 4;
    public static final int STYLE_BLINK_MASK = 8;
    public static final int STYLE_INVERT_MASK = 16;
    public static final int STYLE_HIDDEN_MASK = 32;
    public static final int STYLE_ITALIC_MASK = 64;
    public static final ColorData DEFAULT_BACKGROUND_COLOR = new ColorData(7, 0, 0, ColorMode.DEFAULT_BACKGROUND);
    public static final ColorData DEFAULT_BRIGHT_COLORS = new ColorData(7, 0, 0, ColorMode.SIXTEEN_COLOR_BRIGHT);
    public static final ColorData DEFAULT_COLORS = new ColorData(7, 0, 0, ColorMode.SIXTEEN_COLOR);
    public static final byte DEFAULT_STYLE = 0;
    public static final ColorData DEFAULT_256_COLORS = new ColorData(7, 0, 0, ColorMode.TWO_FIFTY_SIX_COLOR);
    public static final ColorData DEFAULT_TRUE_COLOR_FOREGROUND = new ColorData(238, 238, 238, ColorMode.TRUE_COLOR);
    public static final ColorData DEFAULT_TRUE_COLOR_BACKGROUND = new ColorData(0, 0, 0, ColorMode.TRUE_COLOR);
    public static final int TAB_WIDTH = 4;
    public ColorMode currentForegroundColorMode = ColorMode.SIXTEEN_COLOR;
    public ColorMode currentBackgroundColorMode = ColorMode.SIXTEEN_COLOR;
    public ColorData sixteenColor;
    public ColorData sixteenColorBright;
    public ColorData twoFiftySixColor;
    public ColorData backgroundColor;
    public ColorData foregroundColor;
    public byte style;
    public final int SCROLL_BACK_COUNT = 20;
    public final ByteArrayFIFOQueue input = new ByteArrayFIFOQueue(32);
    public final int[] buffer = new int[38400];
    public final ColorData[] colors = new ColorData[38400];
    public final ColorData[] colorsBackground = new ColorData[38400];
    public final byte[] styles = new byte[38400];
    public final boolean[] tabs = new boolean[80];
    public State state = State.NORMAL;
    public int scrollFirst = 0;
    public int scrollLast = 23;
    public int x;
    public int y;
    public int savedX;
    public int savedY;
    public int altSavedX;
    public int altSavedY;
    public int lastRowToDisplay = 24;
    public int lastRowToDisplayMax = 24;
    public final int[] altBuffer = new int[1920];
    public final ColorData[] altColors = new ColorData[1920];
    public final ColorData[] altColorsBackground = new ColorData[1920];
    public final byte[] altStyles = new byte[1920];
    public final boolean[] altTabs = new boolean[80];
    public final transient Set<RendererModel> renderers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    public transient boolean displayOnly;
    public transient boolean hasPendingBell;
    public boolean continuationByte;
    public int unicode;
    public int bytesRead;
    public int bytesToRead;
    public boolean useG0 = true;
    public int drawingModeG0;
    public int drawingModeG1;
    public int cursorMode;
    public ModeState currentModeState = new ModeState();
    public PrivateModeState currentPrivateModeState = new PrivateModeState();
    public PrivateModeState savePrivateModeState = new PrivateModeState();
    private final CSIManager csiManager = new CSIManager(this);
    private final OSCManager oscManager = new OSCManager(this);
    private final DCSManager dcsManager = new DCSManager(this);
    private final APCManager apcManager = new APCManager(this);

    public int getWidth() {
        return 640;
    }

    public int getHeight() {
        return 384;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RendererView getRenderer() {
        Renderer renderer = new Renderer(this);
        this.renderers.add(renderer);
        return renderer;
    }

    public void incrementLastLineToDisplay() {
        this.incrementLastLineToDisplay(false);
    }

    public void incrementLastLineToDisplay(boolean scroll) {
        boolean originallyEqual;
        if (this.scrollFirst != 0 || this.scrollLast != 23) {
            return;
        }
        boolean bl = originallyEqual = this.lastRowToDisplayMax == this.lastRowToDisplay;
        if (!scroll) {
            this.lastRowToDisplayMax = Math.min(this.lastRowToDisplayMax + 1, 480);
        } else if (this.lastRowToDisplay == this.lastRowToDisplayMax) {
            return;
        }
        this.lastRowToDisplay = originallyEqual ? this.lastRowToDisplayMax : Math.min(this.lastRowToDisplay + 1, this.lastRowToDisplayMax);
        int dirtyLinesMask = 0;
        for (int i = 0; i <= 23; ++i) {
            dirtyLinesMask |= 1 << i;
        }
        int finalDirtyLinesMask = dirtyLinesMask;
        this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(finalDirtyLinesMask, (left, right) -> left | right));
    }

    public void decrementLastLineToDisplay() {
        if (this.scrollFirst != 0 || this.scrollLast != 23) {
            return;
        }
        this.lastRowToDisplay = Math.max(this.lastRowToDisplay - 1, 24);
        int dirtyLinesMask = 0;
        for (int i = 0; i <= 23; ++i) {
            dirtyLinesMask |= 1 << i;
        }
        int finalDirtyLinesMask = dirtyLinesMask;
        this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(finalDirtyLinesMask, (left, right) -> left | right));
    }

    public Terminal() {
        RIS.execute(this);
    }

    public void clear() {
        ColorData c = switch (this.currentBackgroundColorMode) {
            case ColorMode.SIXTEEN_COLOR -> this.sixteenColor;
            case ColorMode.TWO_FIFTY_SIX_COLOR -> this.twoFiftySixColor;
            case ColorMode.TRUE_COLOR -> this.backgroundColor;
            case ColorMode.SIXTEEN_COLOR_BRIGHT -> this.sixteenColorBright;
            default -> DEFAULT_BACKGROUND_COLOR;
        };
        if (this.currentPrivateModeState.isAltBufferEnabled()) {
            Arrays.fill(this.altBuffer, 32);
            Arrays.fill(this.altColors, DEFAULT_COLORS.Copy());
            Arrays.fill(this.altColorsBackground, c.Copy());
            Arrays.fill(this.altStyles, (byte)0);
        } else {
            int startIndex = (this.lastRowToDisplayMax - 24) * 80;
            int endIndex = startIndex + 1920;
            Arrays.fill(this.buffer, startIndex, endIndex, 32);
            Arrays.fill(this.colors, startIndex, endIndex, DEFAULT_COLORS.Copy());
            Arrays.fill(this.colorsBackground, startIndex, endIndex, c.Copy());
            Arrays.fill(this.styles, startIndex, endIndex, (byte)0);
        }
        this.setCursorPos(0, 0);
        this.renderers.forEach(model -> model.getDirtyMask().set(-1));
    }

    public void clearAlt() {
        Arrays.fill(this.altBuffer, 32);
        Arrays.fill(this.altColors, DEFAULT_COLORS.Copy());
        Arrays.fill(this.altColorsBackground, (switch (this.currentBackgroundColorMode) {
            case ColorMode.SIXTEEN_COLOR -> this.sixteenColor;
            case ColorMode.TWO_FIFTY_SIX_COLOR -> this.twoFiftySixColor;
            case ColorMode.TRUE_COLOR -> this.backgroundColor;
            case ColorMode.SIXTEEN_COLOR_BRIGHT -> this.sixteenColorBright;
            default -> DEFAULT_COLORS.Copy();
        }).Copy());
        Arrays.fill(this.altStyles, (byte)0);
    }

    public void clearLine(int y) {
        this.clearLine(y, 0, 80);
    }

    public void clearLine(int y, int fromIndex, int toIndex) {
        this.currentForegroundColorMode = ColorMode.SIXTEEN_COLOR;
        ColorData c = switch (this.currentBackgroundColorMode) {
            case ColorMode.SIXTEEN_COLOR -> this.sixteenColor;
            case ColorMode.TWO_FIFTY_SIX_COLOR -> this.twoFiftySixColor;
            case ColorMode.TRUE_COLOR -> this.backgroundColor;
            case ColorMode.SIXTEEN_COLOR_BRIGHT -> this.sixteenColorBright;
            default -> DEFAULT_BACKGROUND_COLOR;
        };
        if (this.currentPrivateModeState.isAltBufferEnabled()) {
            Arrays.fill(this.altBuffer, y * 80 + fromIndex, y * 80 + toIndex, 32);
            Arrays.fill(this.altColors, y * 80 + fromIndex, y * 80 + toIndex, DEFAULT_COLORS.Copy());
            Arrays.fill(this.altColorsBackground, y * 80 + fromIndex, y * 80 + toIndex, c.Copy());
            Arrays.fill(this.altStyles, y * 80 + fromIndex, y * 80 + toIndex, (byte)0);
        } else {
            int correctedY = y + (this.lastRowToDisplayMax - 24);
            Arrays.fill(this.buffer, correctedY * 80 + fromIndex, correctedY * 80 + toIndex, 32);
            Arrays.fill(this.colors, correctedY * 80 + fromIndex, correctedY * 80 + toIndex, DEFAULT_COLORS.Copy());
            Arrays.fill(this.colorsBackground, correctedY * 80 + fromIndex, correctedY * 80 + toIndex, c.Copy());
            Arrays.fill(this.styles, correctedY * 80 + fromIndex, correctedY * 80 + toIndex, (byte)0);
        }
        this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(1 << y, (prev, next) -> prev | next));
    }

    public void setCursorPos(int x, int y) {
        this.x = Math.max(0, Math.min(79, x));
        this.y = Math.max(0, Math.min(23, y));
    }

    public void setClampedCursorPos(int x, int y) {
        this.setCursorPos(x, Math.max(this.scrollFirst, Math.min(this.scrollLast, y)));
    }

    public void setRelativeCursorPos(int x, int y) {
        if (this.currentPrivateModeState.DECOM) {
            this.setCursorPos(x, Math.min(this.scrollFirst + y, this.scrollLast));
        } else {
            this.setCursorPos(x, y);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDisplayOnly(boolean value) {
        this.displayOnly = value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void releaseRenderer(RendererView renderer) {
        if (renderer instanceof RendererModel) {
            RendererModel rendererModel = (RendererModel)((Object)renderer);
            rendererModel.close();
            this.renderers.remove(rendererModel);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        if (this.hasPendingBell) {
            this.hasPendingBell = false;
            Minecraft client = Minecraft.m_91087_();
            client.execute(() -> client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)NoteBlockInstrument.PLING.m_263188_(), (float)1.0f)));
        }
    }

    public synchronized int readInput() {
        if (this.input.isEmpty()) {
            return -1;
        }
        return this.input.dequeueByte() & 0xFF;
    }

    @Nullable
    public synchronized ByteBuffer getInput() {
        if (this.input.isEmpty()) {
            return null;
        }
        if (!this.currentPrivateModeState.isAltBufferEnabled()) {
            this.lastRowToDisplay = this.lastRowToDisplayMax;
        }
        int dirtyLinesMask = 0;
        for (int i = 0; i <= 23; ++i) {
            dirtyLinesMask |= 1 << i;
        }
        int finalDirtyLinesMask = dirtyLinesMask;
        this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(finalDirtyLinesMask, (left, right) -> left | right));
        ByteBuffer buffer = ByteBuffer.allocate(this.input.size());
        while (!this.input.isEmpty()) {
            buffer.put(this.input.dequeueByte());
        }
        buffer.flip();
        return buffer;
    }

    public synchronized void putInput(String value) {
        this.putInput(ByteBuffer.wrap(value.getBytes()));
    }

    public synchronized void putInput(ByteBuffer values) {
        while (values.hasRemaining()) {
            this.input.enqueue(values.get());
        }
    }

    public synchronized void putOutput(ByteBuffer values) {
        while (values.hasRemaining()) {
            this.putOutput(values.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putOutput(byte value) {
        int[] nArray = this.buffer;
        synchronized (this.buffer) {
            int[] nArray2 = this.altBuffer;
            synchronized (this.altBuffer) {
                int ch = value;
                if (!this.continuationByte && (ch & 0x80) != 0) {
                    this.continuationByte = true;
                    this.bytesToRead = 0;
                    this.bytesRead = 0;
                    this.unicode = 0;
                    if ((ch & 0x40) != 0) {
                        ++this.bytesToRead;
                    } else {
                        this.continuationByte = false;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if ((ch & 0x20) != 0) {
                        ++this.bytesToRead;
                    } else {
                        this.unicode = (ch & 0x1F) << 6;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if ((ch & 0x10) != 0) {
                        ++this.bytesToRead;
                    } else {
                        this.unicode = (ch & 0xF) << 12;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    this.unicode = (ch & 7) << 18;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                if (this.continuationByte) {
                    if ((ch & 0x80) == 0) {
                        this.continuationByte = false;
                        this.bytesToRead = 0;
                        this.bytesRead = 0;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    ++this.bytesRead;
                    this.unicode |= (ch & 0x3F) << (this.bytesToRead - this.bytesRead) * 6;
                    if (this.bytesToRead == this.bytesRead) {
                        this.bytesToRead = 0;
                        this.bytesRead = 0;
                    } else {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
                block4 : switch (this.state) {
                    case NORMAL: {
                        block14 : switch (value) {
                            case 7: {
                                this.hasPendingBell = true;
                                break;
                            }
                            case 27: {
                                this.state = State.ESCAPE;
                                break;
                            }
                            case 14: {
                                this.useG0 = false;
                                break;
                            }
                            case 15: {
                                this.useG0 = true;
                                break;
                            }
                            case 13: {
                                this.setCursorPos(0, this.y);
                                break;
                            }
                            case 10: 
                            case 11: 
                            case 12: {
                                if (this.currentModeState.LNM) {
                                    NEL.execute(this);
                                    break;
                                }
                                IND.execute(this);
                                break;
                            }
                            case 9: {
                                if (this.x >= 80) break;
                                while (true) {
                                    ++this.x;
                                    if (this.x >= 80) break block14;
                                    if (this.currentPrivateModeState.isAltBufferEnabled()) {
                                        if (this.altTabs[this.x]) break block14;
                                        continue;
                                    }
                                    if (this.tabs[this.x]) break;
                                }
                                break;
                            }
                            case 8: {
                                this.setCursorPos(Math.min(this.x, 79) - 1, this.y);
                                break;
                            }
                            default: {
                                this.putChar(this.continuationByte ? this.unicode : ch);
                                break;
                            }
                        }
                        break;
                    }
                    case ESCAPE: {
                        if (ch == 91) {
                            this.csiManager.reset();
                            this.state = State.CONTROL_SEQUENCE;
                            break;
                        }
                        if (ch == 40) {
                            this.state = State.SHIFT_IN_CHARACTER_SET;
                            break;
                        }
                        if (ch == 41) {
                            this.state = State.SHIFT_OUT_CHARACTER_SET;
                            break;
                        }
                        if (ch == 35) {
                            this.state = State.HASH;
                            break;
                        }
                        if (ch == 80) {
                            this.dcsManager.reset();
                            this.state = State.DCS;
                            break;
                        }
                        if (ch == 93) {
                            this.oscManager.reset();
                            this.state = State.OSC;
                            break;
                        }
                        if (ch == 95) {
                            this.apcManager.reset();
                            this.state = State.APC;
                            break;
                        }
                        this.state = State.NORMAL;
                        switch (ch) {
                            case 68: {
                                IND.execute(this);
                                break block4;
                            }
                            case 69: {
                                NEL.execute(this);
                                break block4;
                            }
                            case 77: {
                                RI.execute(this);
                                break block4;
                            }
                            case 55: {
                                DECSC.execute(this);
                                break block4;
                            }
                            case 56: {
                                DECRC.execute(this);
                                break block4;
                            }
                            case 72: {
                                HTS.execute(this);
                                break block4;
                            }
                            case 99: {
                                RIS.execute(this);
                                break block4;
                            }
                            case 61: {
                                break block4;
                            }
                            case 62: {
                                break block4;
                            }
                        }
                        System.out.println("Invalid escape: " + (char)ch);
                        break;
                    }
                    case CONTROL_SEQUENCE: {
                        this.csiManager.handle((char)ch);
                        break;
                    }
                    case SHIFT_IN_CHARACTER_SET: 
                    case SHIFT_OUT_CHARACTER_SET: {
                        this.state = State.NORMAL;
                        switch (ch) {
                            case 65: {
                                break block4;
                            }
                            case 66: {
                                this.drawingModeG0 = 0;
                                break block4;
                            }
                            case 48: {
                                this.drawingModeG0 = 1;
                                break block4;
                            }
                            case 49: {
                                break block4;
                            }
                        }
                        break;
                    }
                    case HASH: {
                        this.state = State.NORMAL;
                        switch (ch) {
                            case 51: {
                                break block4;
                            }
                            case 52: {
                                break block4;
                            }
                            case 53: {
                                break block4;
                            }
                            case 54: {
                                break block4;
                            }
                            case 56: {
                                if (this.currentPrivateModeState.isAltBufferEnabled()) {
                                    Arrays.fill(this.altBuffer, 69);
                                } else {
                                    Arrays.fill(this.buffer, (this.lastRowToDisplayMax - 24) * 80, 1920, 69);
                                }
                                this.renderers.forEach(model -> model.getDirtyMask().set(-1));
                            }
                        }
                        break;
                    }
                    case DCS: {
                        this.dcsManager.handle(ch);
                        break;
                    }
                    case OSC: {
                        this.oscManager.handle(ch);
                        break;
                    }
                    case APC: {
                        this.apcManager.handle(ch);
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public synchronized void putInput(char value) {
        this.putInput((byte)value);
    }

    public synchronized void putInput(byte value) {
        this.input.enqueue(value);
    }

    public void putResponse(String value) {
        for (int i = 0; i < value.length(); ++i) {
            this.putResponse((byte)value.charAt(i));
        }
    }

    public void putResponse(byte value) {
        if (!this.displayOnly) {
            this.putInput(value);
        }
    }

    public void shiftUp(int count) {
        if (this.currentPrivateModeState.isAltBufferEnabled()) {
            this.shiftLines(this.scrollFirst + 1, this.scrollLast, -count);
        } else if (this.lastRowToDisplay == 480 || this.scrollLast != 23 || this.scrollFirst != 0) {
            this.shiftLines(this.scrollFirst != 0 ? this.scrollFirst + (this.lastRowToDisplayMax - 24) + 1 : 1, this.scrollLast != 23 ? this.scrollLast + (this.lastRowToDisplayMax - 24) : 479, -count);
        }
    }

    public void shiftDown(int count) {
        if (this.currentPrivateModeState.isAltBufferEnabled()) {
            this.shiftLines(this.scrollFirst, this.scrollLast - 1, count);
        } else {
            this.shiftLines(this.scrollFirst != 0 ? this.scrollFirst + (this.lastRowToDisplayMax - 24) : 0, this.scrollLast != 23 ? this.scrollLast + (this.lastRowToDisplayMax - 24) - 1 : 478, count);
        }
    }

    public void shiftUpOne() {
        this.shiftUp(1);
    }

    public void shiftDownOne() {
        this.shiftDown(1);
    }

    public void shiftLines(int firstLine, int lastLine, int count) {
        int shiftUpOrDown;
        if (count == 0) {
            return;
        }
        int srcIndex = firstLine * 80;
        int charCount = (lastLine + 1) * 80 - srcIndex;
        int dstIndex = srcIndex + count * 80;
        ColorData c = switch (this.currentBackgroundColorMode) {
            case ColorMode.SIXTEEN_COLOR -> this.sixteenColor;
            case ColorMode.TWO_FIFTY_SIX_COLOR -> this.twoFiftySixColor;
            case ColorMode.TRUE_COLOR -> this.backgroundColor;
            case ColorMode.SIXTEEN_COLOR_BRIGHT -> this.sixteenColorBright;
            default -> DEFAULT_BACKGROUND_COLOR;
        };
        int n = shiftUpOrDown = count > 0 ? srcIndex : dstIndex + charCount;
        if (this.currentPrivateModeState.isAltBufferEnabled()) {
            System.arraycopy(this.altBuffer, srcIndex, this.altBuffer, dstIndex, charCount);
            System.arraycopy(this.altColors, srcIndex, this.altColors, dstIndex, charCount);
            System.arraycopy(this.altColorsBackground, srcIndex, this.altColorsBackground, dstIndex, charCount);
            System.arraycopy(this.altStyles, srcIndex, this.altStyles, dstIndex, charCount);
            int clearCount = Math.abs(count * 80);
            Arrays.fill(this.altBuffer, shiftUpOrDown, shiftUpOrDown + clearCount, 32);
            Arrays.fill(this.altColors, shiftUpOrDown, shiftUpOrDown + clearCount, DEFAULT_COLORS.Copy());
            Arrays.fill(this.altColorsBackground, shiftUpOrDown, shiftUpOrDown + clearCount, c.Copy());
            Arrays.fill(this.altStyles, shiftUpOrDown, shiftUpOrDown + clearCount, (byte)0);
            int dirtyLinesMask = 0;
            int dirtyStart = Math.min(firstLine, firstLine + count);
            int dirtyEnd = Math.max(lastLine, lastLine + count);
            for (int i = dirtyStart; i <= dirtyEnd; ++i) {
                dirtyLinesMask |= 1 << i;
            }
            int finalDirtyLinesMask = dirtyLinesMask;
            this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(finalDirtyLinesMask, (left, right) -> left | right));
        } else {
            System.arraycopy(this.buffer, srcIndex, this.buffer, dstIndex, charCount);
            System.arraycopy(this.colors, srcIndex, this.colors, dstIndex, charCount);
            System.arraycopy(this.colorsBackground, srcIndex, this.colorsBackground, dstIndex, charCount);
            System.arraycopy(this.styles, srcIndex, this.styles, dstIndex, charCount);
            int clearCount = Math.abs(count * 80);
            Arrays.fill(this.buffer, shiftUpOrDown, shiftUpOrDown + clearCount, 32);
            Arrays.fill(this.colors, shiftUpOrDown, shiftUpOrDown + clearCount, DEFAULT_COLORS.Copy());
            Arrays.fill(this.colorsBackground, shiftUpOrDown, shiftUpOrDown + clearCount, c.Copy());
            Arrays.fill(this.styles, shiftUpOrDown, shiftUpOrDown + clearCount, (byte)0);
            int dirtyLinesMask = 0;
            int dirtyStart = Math.min(firstLine, firstLine + count);
            int dirtyEnd = Math.max(lastLine, lastLine + count);
            for (int i = dirtyStart; i <= dirtyEnd; ++i) {
                int globalI = this.lastRowToDisplayMax - (24 - i);
                int localI = 24 + (globalI - this.lastRowToDisplay);
                dirtyLinesMask |= 1 << localI;
            }
            int finalDirtyLinesMask = dirtyLinesMask;
            this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(finalDirtyLinesMask, (left, right) -> left | right));
        }
    }

    private void putChar(int ch) {
        int curMode;
        if (this.continuationByte) {
            this.continuationByte = false;
        }
        if (Character.isISOControl(ch)) {
            return;
        }
        int n = curMode = this.useG0 ? this.drawingModeG0 : this.drawingModeG1;
        if (curMode == 1) {
            switch (ch) {
                case 108: {
                    ch = "\u250c".codePointAt(0);
                    break;
                }
                case 107: {
                    ch = "\u2510".codePointAt(0);
                    break;
                }
                case 109: {
                    ch = "\u2514".codePointAt(0);
                    break;
                }
                case 106: {
                    ch = "\u2518".codePointAt(0);
                    break;
                }
                case 113: {
                    ch = "\u2500".codePointAt(0);
                    break;
                }
                case 120: {
                    ch = "\u2502".codePointAt(0);
                    break;
                }
                case 110: {
                    ch = "\u253c".codePointAt(0);
                    break;
                }
                case 126: {
                    ch = "B".codePointAt(0);
                    break;
                }
                case 117: {
                    ch = "\u2524".codePointAt(0);
                    break;
                }
                case 116: {
                    ch = "\u251c".codePointAt(0);
                    break;
                }
                case 118: {
                    ch = "\u2534".codePointAt(0);
                    break;
                }
                case 119: {
                    ch = "\u252c".codePointAt(0);
                }
            }
        }
        if (this.x >= 80) {
            if (this.currentPrivateModeState.DECAWM) {
                NEL.execute(this);
            } else {
                this.setCursorPos(79, this.y);
            }
        }
        this.setChar(this.x, this.y, ch);
        ++this.x;
    }

    private void setChar(int x, int y, int ch) {
        if (this.currentPrivateModeState.isAltBufferEnabled()) {
            int index = x + y * 80;
            this.altBuffer[index] = ch;
            switch (this.currentForegroundColorMode) {
                case SIXTEEN_COLOR: {
                    this.altColors[index] = this.sixteenColor.Copy();
                    break;
                }
                case TWO_FIFTY_SIX_COLOR: {
                    this.altColors[index] = this.twoFiftySixColor.Copy();
                    break;
                }
                case TRUE_COLOR: {
                    this.altColors[index] = this.foregroundColor.Copy();
                    break;
                }
                case SIXTEEN_COLOR_BRIGHT: {
                    this.altColors[index] = this.sixteenColorBright.Copy();
                }
            }
            switch (this.currentBackgroundColorMode) {
                case SIXTEEN_COLOR: {
                    this.altColorsBackground[index] = this.sixteenColor.Copy();
                    break;
                }
                case TWO_FIFTY_SIX_COLOR: {
                    this.altColorsBackground[index] = this.twoFiftySixColor.Copy();
                    break;
                }
                case TRUE_COLOR: {
                    this.altColorsBackground[index] = this.backgroundColor.Copy();
                    break;
                }
                case SIXTEEN_COLOR_BRIGHT: {
                    this.altColorsBackground[index] = this.sixteenColorBright.Copy();
                }
            }
            this.altStyles[index] = this.style;
            this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(1 << y, (prev, next) -> prev | next));
        } else {
            int correctedY = y + (this.lastRowToDisplayMax - 24);
            int index = x + correctedY * 80;
            this.buffer[index] = ch;
            switch (this.currentForegroundColorMode) {
                case SIXTEEN_COLOR: {
                    this.colors[index] = this.sixteenColor.Copy();
                    break;
                }
                case TWO_FIFTY_SIX_COLOR: {
                    this.colors[index] = this.twoFiftySixColor.Copy();
                    break;
                }
                case TRUE_COLOR: {
                    this.colors[index] = this.foregroundColor.Copy();
                    break;
                }
                case SIXTEEN_COLOR_BRIGHT: {
                    this.colors[index] = this.sixteenColorBright.Copy();
                }
            }
            switch (this.currentBackgroundColorMode) {
                case SIXTEEN_COLOR: {
                    this.colorsBackground[index] = this.sixteenColor.Copy();
                    break;
                }
                case TWO_FIFTY_SIX_COLOR: {
                    this.colorsBackground[index] = this.twoFiftySixColor.Copy();
                    break;
                }
                case TRUE_COLOR: {
                    this.colorsBackground[index] = this.backgroundColor.Copy();
                    break;
                }
                case SIXTEEN_COLOR_BRIGHT: {
                    this.colorsBackground[index] = this.sixteenColorBright.Copy();
                }
            }
            this.styles[index] = this.style;
            int globalY = this.lastRowToDisplayMax - (24 - y);
            int localY = 24 + (globalY - this.lastRowToDisplay);
            this.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(1 << localY, (prev, next) -> prev | next));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Renderer
    implements RendererModel,
    RendererView {
        public static final int[] BRIGHT_COLORS = new int[]{0x7B7B7B, 16729380, 3866459, 16767760, 1212927, 16726750, 2612735, 0xFFFFFF};
        public static final int[] COLORS = new int[]{0x555555, 0xEE3322, 0x33DD44, 0xFFCC11, 0x1188EE, 0xDD33CC, 0x22CCDD, 0xEEEEEE};
        public static final int[] DIM_COLORS = new int[]{0, 0x772211, 0x116622, 0x886611, 0x115588, 0x771177, 0x116677, 0x777777};
        public static final int[] COLORS_256 = new int[]{0, 0x772211, 0x116622, 0x886611, 0x115588, 0x771177, 0x116677, 0x777777, 0x555555, 0xEE3322, 0x33DD44, 0xFFCC11, 0x1188EE, 0xDD33CC, 0x22CCDD, 0xEEEEEE, 0, 95, 135, 175, 215, 255, 24320, 24415, 24455, 24495, 24535, 24575, 34560, 34655, 34695, 34735, 34775, 34815, 44800, 44895, 44935, 44975, 45015, 45055, 55040, 55135, 55175, 55215, 55255, 55295, 65280, 65375, 65415, 65455, 65495, 65535, 0x5F0000, 0x5F005F, 6226055, 6226095, 6226135, 0x5F00FF, 0x5F5F00, 0x5F5F5F, 6250375, 0x5F5FAF, 6250455, 0x5F5FFF, 6260480, 6260575, 6260615, 6260655, 6260695, 6260735, 6270720, 0x5FAF5F, 6270855, 0x5FAFAF, 6270935, 0x5FAFFF, 6280960, 6281055, 6281095, 6281135, 6281175, 6281215, 0x5FFF00, 0x5FFF5F, 6291335, 0x5FFFAF, 6291415, 0x5FFFFF, 0x870000, 8847455, 0x870087, 8847535, 8847575, 8847615, 8871680, 8871775, 8871815, 8871855, 8871895, 8871935, 0x878700, 8882015, 0x878787, 8882095, 0x8787D7, 0x8787FF, 8892160, 8892255, 8892295, 8892335, 8892375, 8892415, 8902400, 8902495, 0x87D787, 8902575, 0x87D7D7, 8902655, 8912640, 8912735, 0x87FF87, 8912815, 8912855, 0x87FFFF, 0xAF0000, 11468895, 11468935, 0xAF00AF, 11469015, 0xAF00FF, 11493120, 0xAF5F5F, 11493255, 0xAF5FAF, 11493335, 0xAF5FFF, 11503360, 11503455, 11503495, 11503535, 11503575, 11503615, 0xAFAF00, 0xAFAF5F, 11513735, 0xAFAFAF, 11513815, 0xAFAFFF, 11523840, 11523935, 11523975, 11524015, 11524055, 11524095, 0xAFFF00, 0xAFFF5F, 11534215, 0xAFFFAF, 11534295, 0xAFFFFF, 0xD70000, 14090335, 14090375, 14090415, 0xD700D7, 14090495, 14114560, 14114655, 14114695, 14114735, 14114775, 14114815, 14124800, 14124895, 0xD78787, 14124975, 0xD787D7, 14125055, 14659328, 14659423, 14659463, 0xDFAFAF, 0xDFAFDF, 0xDFAFFF, 0xDFDF00, 0xDFDF5F, 14671751, 0xDFDFAF, 0xDFDFDF, 0xDFDFFF, 0xDFFF00, 0xDFFF5F, 14679943, 0xDFFFAF, 0xDFFFDF, 0xDFFFFF, 0xFF0000, 0xFF005F, 16711815, 0xFF00AF, 0xFF00DF, 0xFF00FF, 0xFF5F00, 0xFF5F5F, 16736135, 0xFF5FAF, 0xFF5FDF, 0xFF5FFF, 16746240, 16746335, 0xFF8787, 16746415, 16746463, 0xFF87FF, 0xFFAF00, 0xFFAF5F, 16756615, 0xFFAFAF, 0xFFAFDF, 0xFFAFFF, 0xFFDF00, 0xFFDF5F, 16768903, 0xFFDFAF, 0xFFDFDF, 0xFFDFFF, 0xFFFF00, 0xFFFF5F, 0xFFFF87, 0xFFFFAF, 0xFFFFDF, 0xFFFFFF, 526344, 0x121212, 0x1C1C1C, 0x262626, 0x303030, 0x3A3A3A, 0x444444, 0x4E4E4E, 0x585858, 0x626262, 0x6C6C6C, 0x767676, 0x808080, 0x8A8A8A, 0x949494, 0x9E9E9E, 0xA8A8A8, 0xB2B2B2, 0xBCBCBC, 0xC6C6C6, 0xD0D0D0, 0xDADADA, 0xE4E4E4, 0xEEEEEE};
        public final Terminal terminal;
        public final VertexBuffer[] lines = new VertexBuffer[24];
        public final AtomicInteger dirty = new AtomicInteger(-1);

        public Renderer(Terminal terminal) {
            this.terminal = terminal;
        }

        @Override
        public void render(PoseStack stack, Matrix4f projectionMatrix) {
            boolean steady;
            if (this.terminal.currentPrivateModeState.APPLICATION_SYNC) {
                return;
            }
            this.validateLineCache();
            this.renderBuffer(stack, projectionMatrix);
            switch (this.terminal.cursorMode) {
                case 2: 
                case 4: 
                case 6: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = steady = false;
                }
            }
            if (steady || (System.currentTimeMillis() + (long)this.terminal.hashCode()) % 1000L > 500L) {
                this.renderCursor(stack);
            }
        }

        @Override
        public AtomicInteger getDirtyMask() {
            return this.dirty;
        }

        @Override
        public void close() {
            for (int i = 0; i < this.lines.length; ++i) {
                VertexBuffer line = this.lines[i];
                if (line == null) continue;
                line.close();
                this.lines[i] = null;
            }
        }

        public int findLineIndex(VertexBuffer[] vba, VertexBuffer vb) {
            for (int i = 0; i < vba.length; ++i) {
                if (vba[i] != vb) continue;
                return i;
            }
            return -1;
        }

        public void renderBuffer(PoseStack stack, Matrix4f projectionMatrix) {
            ShaderInstance shader = GameRenderer.m_172814_();
            if (shader == null) {
                return;
            }
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FontHandling.getAtlas());
            for (VertexBuffer line : this.lines) {
                if (line.m_231230_()) continue;
                try {
                    line.m_85921_();
                    line.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shader);
                    VertexBuffer.m_85931_();
                }
                catch (Exception e) {
                    System.out.println("ERROR: " + e.getMessage());
                    System.out.println(this.findLineIndex(this.lines, line));
                }
            }
            RenderSystem.depthMask((boolean)true);
        }

        public void validateLineCache() {
            if (this.dirty.get() == 0) {
                return;
            }
            int mask = this.dirty.getAndSet(0);
            for (int row = 0; row < this.lines.length; ++row) {
                if ((mask & 1 << row) == 0) continue;
                BufferBuilder builder = Tesselator.m_85913_().m_85915_();
                Matrix4f matrix = new Matrix4f().translate(0.0f, (float)(row * 16), 0.0f);
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
                this.renderBackground(matrix, builder, row);
                this.renderForeground(matrix, builder, row);
                BufferBuilder.RenderedBuffer rb = builder.m_231175_();
                if (this.lines[row] == null) {
                    this.lines[row] = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
                } else if (this.lines[row] != null) {
                    this.lines[row].close();
                    this.lines[row] = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
                }
                if (this.lines[row].m_231230_()) continue;
                this.lines[row].m_85921_();
                this.lines[row].m_231221_(rb);
                VertexBuffer.m_85931_();
            }
        }

        public void renderBackground(Matrix4f matrix, BufferBuilder buffer, int row) {
            int index;
            float backgroundStartX = -1.0f;
            int backgroundColor = 0;
            float tx = 0.0f;
            boolean useAltBuffer = this.terminal.currentPrivateModeState.isAltBufferEnabled();
            int col = 0;
            int n = index = useAltBuffer ? row * 80 : (row + (this.terminal.lastRowToDisplay - 24)) * 80;
            while (col < 80) {
                ColorData color;
                boolean invertBackground;
                byte style = useAltBuffer ? this.terminal.altStyles[index] : this.terminal.styles[index];
                boolean bl = invertBackground = (style & 0x10) != 0;
                ColorData colorData = !invertBackground ? (useAltBuffer ? this.terminal.altColorsBackground[index] : this.terminal.colorsBackground[index]) : (color = useAltBuffer ? this.terminal.altColors[index] : this.terminal.colors[index]);
                if ((style & 0x20) == 0) {
                    boolean hasBackground;
                    int[] palette = (style & 2) != 0 ? DIM_COLORS : COLORS;
                    int background = switch (color.Mode) {
                        default -> throw new IncompatibleClassChangeError();
                        case ColorMode.SIXTEEN_COLOR -> palette[!invertBackground ? color.G : color.R];
                        case ColorMode.TWO_FIFTY_SIX_COLOR -> COLORS_256[!invertBackground ? color.G : color.R];
                        case ColorMode.TRUE_COLOR -> color.ToInt();
                        case ColorMode.SIXTEEN_COLOR_BRIGHT -> BRIGHT_COLORS[!invertBackground ? color.G : color.R];
                        case ColorMode.DEFAULT_BACKGROUND -> 0;
                    };
                    boolean hadBackground = backgroundStartX >= 0.0f;
                    boolean bl2 = hasBackground = background != 0;
                    if (!hadBackground && hasBackground) {
                        backgroundStartX = tx;
                        backgroundColor = background;
                    } else if (hadBackground && (!hasBackground || backgroundColor != background)) {
                        this.renderBackground(matrix, buffer, backgroundStartX, tx, backgroundColor);
                        if (hasBackground) {
                            backgroundStartX = tx;
                            backgroundColor = background;
                        } else {
                            backgroundStartX = -1.0f;
                        }
                    }
                    tx += 8.0f;
                }
                ++col;
                ++index;
            }
            if (backgroundStartX >= 0.0f) {
                this.renderBackground(matrix, buffer, backgroundStartX, tx, backgroundColor);
            }
        }

        public void renderBackground(Matrix4f matrix, BufferBuilder buffer, float x0, float x1, int color) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            buffer.m_252986_(matrix, x0, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, x1, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, x1, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, x0, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
        }

        public void renderForeground(Matrix4f matrix, BufferBuilder buffer, int row) {
            int index;
            float tx = 0.0f;
            boolean useAltBuffer = this.terminal.currentPrivateModeState.isAltBufferEnabled();
            int col = 0;
            int n = index = useAltBuffer ? row * 80 : (row + (this.terminal.lastRowToDisplay - 24)) * 80;
            while (col < 80) {
                ColorData color;
                boolean invertBackground;
                byte style = useAltBuffer ? this.terminal.altStyles[index] : this.terminal.styles[index];
                boolean bl = invertBackground = (style & 0x10) != 0;
                ColorData colorData = !invertBackground ? (useAltBuffer ? this.terminal.altColors[index] : this.terminal.colors[index]) : (color = useAltBuffer ? this.terminal.altColorsBackground[index] : this.terminal.colorsBackground[index]);
                if ((style & 0x20) == 0) {
                    int[] palette = (style & 2) != 0 ? DIM_COLORS : COLORS;
                    int foreground = switch (color.Mode) {
                        default -> throw new IncompatibleClassChangeError();
                        case ColorMode.SIXTEEN_COLOR -> palette[!invertBackground ? color.R : color.G];
                        case ColorMode.TWO_FIFTY_SIX_COLOR -> COLORS_256[!invertBackground ? color.R : color.G];
                        case ColorMode.TRUE_COLOR -> color.ToInt();
                        case ColorMode.SIXTEEN_COLOR_BRIGHT -> BRIGHT_COLORS[!invertBackground ? color.R : color.G];
                        case ColorMode.DEFAULT_BACKGROUND -> 0;
                    };
                    int character = useAltBuffer ? this.terminal.altBuffer[index] : this.terminal.buffer[index];
                    this.renderForeground(matrix, buffer, tx, character, foreground, style);
                    tx += 8.0f;
                }
                ++col;
                ++index;
            }
        }

        public void renderForeground(Matrix4f matrix, BufferBuilder buffer, float offset, int character, int color, byte style) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            if (Renderer.isPrintableCharacter(character)) {
                FontHandling.FontStyle font = this.getFontStyle(style);
                Glyph glyph = FontHandling.getGlyph(character, font);
                if (font == FontHandling.FontStyle.ITALIC || font == FontHandling.FontStyle.BOLD_ITALIC) {
                    buffer.m_252986_(matrix, offset, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(glyph.uStart, glyph.vEnd).m_5752_();
                    buffer.m_252986_(matrix, offset + 8.0f + 8.0f, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(glyph.uEnd, glyph.vEnd).m_5752_();
                    buffer.m_252986_(matrix, offset + 8.0f + 8.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(glyph.uEnd, glyph.vStart).m_5752_();
                    buffer.m_252986_(matrix, offset, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(glyph.uStart, glyph.vStart).m_5752_();
                } else {
                    buffer.m_252986_(matrix, offset, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(glyph.uStart, glyph.vEnd).m_5752_();
                    buffer.m_252986_(matrix, offset + 8.0f, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(glyph.uEnd, glyph.vEnd).m_5752_();
                    buffer.m_252986_(matrix, offset + 8.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(glyph.uEnd, glyph.vStart).m_5752_();
                    buffer.m_252986_(matrix, offset, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(glyph.uStart, glyph.vStart).m_5752_();
                }
            }
            if ((style & 4) != 0) {
                buffer.m_252986_(matrix, offset, 13.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, offset + 8.0f, 13.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, offset + 8.0f, 14.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, offset, 14.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            }
        }

        private FontHandling.FontStyle getFontStyle(byte style) {
            FontHandling.FontStyle font = (style & 1) != 0 && (style & 0x40) != 0 ? FontHandling.FontStyle.BOLD_ITALIC : ((style & 1) != 0 ? FontHandling.FontStyle.BOLD : ((style & 0x40) != 0 ? FontHandling.FontStyle.ITALIC : FontHandling.FontStyle.REGULAR));
            return font;
        }

        public void renderCursor(PoseStack stack) {
            BufferUploader.m_166835_();
            if (!this.terminal.currentPrivateModeState.DECTCEM) {
                return;
            }
            int globalY = this.terminal.lastRowToDisplayMax - (24 - this.terminal.y);
            int localY = 24 + (globalY - this.terminal.lastRowToDisplay);
            boolean useAltBuffer = this.terminal.currentPrivateModeState.isAltBufferEnabled();
            if (this.terminal.x < 0 || this.terminal.x >= 80 || !useAltBuffer && localY < 0 || this.terminal.y < 0 || !useAltBuffer && localY >= 24 || this.terminal.y >= 24 || !useAltBuffer && globalY > this.terminal.lastRowToDisplay) {
                return;
            }
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::m_172811_);
            stack.m_85836_();
            stack.m_252880_((float)(this.terminal.x * 8), (float)((useAltBuffer ? this.terminal.y : localY) * 16), 0.0f);
            Matrix4f matrix = stack.m_85850_().m_252922_();
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            int foreground = COLORS[7];
            float r = (float)(foreground >> 16 & 0xFF) / 255.0f;
            float g = (float)(foreground >> 8 & 0xFF) / 255.0f;
            float b = (float)(foreground & 0xFF) / 255.0f;
            switch (this.terminal.cursorMode) {
                case 0: 
                case 1: 
                case 2: {
                    buffer.m_252986_(matrix, 0.0f, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_252986_(matrix, 8.0f, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_252986_(matrix, 8.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    break;
                }
                case 3: 
                case 4: {
                    buffer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_252986_(matrix, 8.0f, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_252986_(matrix, 8.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    break;
                }
                case 5: 
                case 6: {
                    buffer.m_252986_(matrix, 0.0f, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_252986_(matrix, 1.0f, 16.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                }
            }
            BufferBuilder.RenderedBuffer rb = buffer.m_231175_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)rb);
            stack.m_85849_();
            RenderSystem.depthMask((boolean)true);
        }

        public static boolean isPrintableCharacter(int ch) {
            return ch == 0 || ch > 32 && ch <= 126 || ch >= 177;
        }
    }

    public static enum ColorMode {
        DEFAULT_BACKGROUND,
        SIXTEEN_COLOR,
        TWO_FIFTY_SIX_COLOR,
        TRUE_COLOR,
        SIXTEEN_COLOR_BRIGHT;

    }

    public static class ColorData {
        public int R;
        public int G;
        public int B;
        public ColorMode Mode;

        public ColorData() {
            this.R = 0;
            this.G = 0;
            this.B = 0;
            ColorMode Mode2 = ColorMode.SIXTEEN_COLOR;
        }

        public ColorData(int r, int g, int b, ColorMode mode) {
            this.R = r;
            this.G = g;
            this.B = b;
            this.Mode = mode;
        }

        public int ToInt() {
            return (this.R & 0xFF) << 16 | (this.G & 0xFF) << 8 | this.B & 0xFF;
        }

        public ColorData Copy() {
            return new ColorData(this.R, this.G, this.B, this.Mode);
        }
    }

    public static enum State {
        NORMAL,
        ESCAPE,
        SHIFT_IN_CHARACTER_SET,
        SHIFT_OUT_CHARACTER_SET,
        HASH,
        DCS,
        OSC,
        APC,
        CONTROL_SEQUENCE;

    }

    public static interface RendererModel {
        public AtomicInteger getDirtyMask();

        public void close();
    }

    public static final class DrawingMode {
        public static final int ASCII = 0;
        public static final int SPECIAL_GRAPHICS = 1;
    }

    public static final class Color {
        static final int BLACK = 0;
        static final int RED = 1;
        static final int GREEN = 2;
        static final int YELLOW = 3;
        static final int BLUE = 4;
        static final int MAGENTA = 5;
        static final int CYAN = 6;
        static final int WHITE = 7;
    }

    public static interface RendererView {
        public void render(PoseStack var1, Matrix4f var2);
    }

    public static final class CursorMode {
        public static final int DEFAULT = 0;
        public static final int BLINK_BLOCK = 1;
        public static final int STEADY_BLOCK = 2;
        public static final int BLINK_UNDERLINE = 3;
        public static final int STEADY_UNDERLINE = 4;
        public static final int BLINKING_BAR_LINE = 5;
        public static final int STEADY_BAR_LINE = 6;
    }
}

