/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal.modes;

import java.util.ArrayList;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.oc2.common.vm.terminal.modes.MouseMode;

@Serialized
public class PrivateModeState {
    public boolean DECCKM = false;
    public boolean DECANM = false;
    public boolean DECCOLM = false;
    public boolean DECSCLM = false;
    public boolean DECSCNM = false;
    public boolean DECOM = false;
    public boolean DECAWM = true;
    public boolean DECARM = true;
    public boolean X10MM = false;
    public boolean TOOLBAR = false;
    public boolean START_BLINKING_CURSOR = false;
    public boolean START_BLINKING_CURSOR2 = false;
    public boolean XORBLINK = false;
    public boolean DECPFF = false;
    public boolean DECPEX = false;
    public boolean DECTCEM = true;
    public boolean SHOW_SCROLL = false;
    public boolean FONT_SHIFT = false;
    public boolean TEKTRONIX = false;
    public boolean ENABLE_80_132 = false;
    public boolean MORE_FIX = false;
    public boolean DECNRCM = false;
    public boolean DECGEPM = false;
    public boolean MARG_BELL = false;
    public boolean XTREVWRAP = false;
    public boolean XTLOGGING = false;
    public boolean ALT_BUFFER = false;
    public boolean DECNKM = false;
    public boolean DECBKM = false;
    public boolean DECLRMM = false;
    public boolean DECSDM = false;
    public boolean DECNCSM = false;
    public boolean X11MM = false;
    public boolean HILITE_MOUSE = false;
    public boolean CELL_MOTION_MOUSE = false;
    public boolean ALL_MOTION_MOUSE_TRACKING = false;
    public boolean FOCUS_IN_FOCUS_OUT = false;
    public boolean UTF8_MOUSE = false;
    public boolean SGR_MOUSE = false;
    public boolean ALTERNATE_SCROLL_MODE = false;
    public boolean SCROLL_BOTTOM_ON_OUTPUT = false;
    public boolean SCROLL_BOTTOM_ON_KEY_PRESS = false;
    public boolean FAST_SCROLL = false;
    public boolean URXVT_MOUSE = false;
    public boolean SGR_MOUSE_PIXEL = false;
    public boolean META_KEY = false;
    public boolean SPECIAL_MODIFIERS = false;
    public boolean META_SENDS_ESCAPE = false;
    public boolean DEL_EDIT_KEYPAD_DEL = false;
    public boolean ALT_SENDS_ESC = false;
    public boolean KEEP_SELECTION = false;
    public boolean USE_CLIP = false;
    public boolean ENABLE_URGENCY = false;
    public boolean RAISE_ON_CTRL_G = false;
    public boolean KEEP_CLIP = false;
    public boolean EXT_REV_WRAP = false;
    public boolean ALLOW_ALT_BUFFER = false;
    public boolean SWITCH_ALT_BUFFER = false;
    public boolean SAVE_CURSOR = false;
    public boolean SAVE_CLEAR_AND_SWITCH = false;
    public boolean SET_TERMINFO_FUNC_KEY_MODE = false;
    public boolean SET_SUN_KEY_MODE = false;
    public boolean SET_HP_K0EY_MODE = false;
    public boolean SET_SCO_KEY_MODE = false;
    public boolean SET_LEGACY_KEYBOARD = false;
    public boolean SET_VT220_KEYBOARD = false;
    public boolean ENABLE_READLINE_MOUSE_1 = false;
    public boolean ENABLE_READLINE_MOUSE_2 = false;
    public boolean ENABLE_READLINE_MOUSE_3 = false;
    public boolean SET_BRACKETED_PASTE = false;
    public boolean ENABLE_READLINE_CHAR_QUOTE = false;
    public boolean ENABLE_READLINE_NEWLINE_PASTE = false;
    public boolean APPLICATION_SYNC = false;
    public boolean APPLICATION_ESC_MODE = false;

    public int getModeForRequest(int mode) {
        Boolean modeState = this.getMode(mode);
        if (modeState == null) {
            return 0;
        }
        if (modeState.booleanValue()) {
            return 1;
        }
        return 2;
    }

    @Nullable
    public Boolean getMode(int mode) {
        return switch (mode) {
            case 1 -> this.DECCKM;
            case 2 -> this.DECANM;
            case 3 -> this.DECCOLM;
            case 4 -> this.DECSCLM;
            case 5 -> this.DECSCNM;
            case 6 -> this.DECOM;
            case 7 -> this.DECAWM;
            case 8 -> this.DECARM;
            case 9 -> this.X10MM;
            case 10 -> this.TOOLBAR;
            case 12 -> this.START_BLINKING_CURSOR;
            case 13 -> this.START_BLINKING_CURSOR2;
            case 14 -> this.XORBLINK;
            case 18 -> this.DECPFF;
            case 19 -> this.DECPEX;
            case 25 -> this.DECTCEM;
            case 30 -> this.SHOW_SCROLL;
            case 35 -> this.FONT_SHIFT;
            case 38 -> this.TEKTRONIX;
            case 40 -> this.ENABLE_80_132;
            case 41 -> this.MORE_FIX;
            case 42 -> this.DECNRCM;
            case 43 -> this.DECGEPM;
            case 44 -> this.MARG_BELL;
            case 45 -> this.XTREVWRAP;
            case 46 -> this.XTLOGGING;
            case 47 -> this.ALT_BUFFER;
            case 66 -> this.DECNKM;
            case 67 -> this.DECBKM;
            case 69 -> this.DECLRMM;
            case 80 -> this.DECSDM;
            case 96 -> this.DECNCSM;
            case 1000 -> this.X11MM;
            case 1001 -> this.HILITE_MOUSE;
            case 1002 -> this.CELL_MOTION_MOUSE;
            case 1003 -> this.ALL_MOTION_MOUSE_TRACKING;
            case 1004 -> this.FOCUS_IN_FOCUS_OUT;
            case 1005 -> this.UTF8_MOUSE;
            case 1006 -> this.SGR_MOUSE;
            case 1007 -> this.ALTERNATE_SCROLL_MODE;
            case 1010 -> this.SCROLL_BOTTOM_ON_OUTPUT;
            case 1011 -> this.SCROLL_BOTTOM_ON_KEY_PRESS;
            case 1014 -> this.FAST_SCROLL;
            case 1015 -> this.URXVT_MOUSE;
            case 1016 -> this.SGR_MOUSE_PIXEL;
            case 1034 -> this.META_KEY;
            case 1035 -> this.SPECIAL_MODIFIERS;
            case 1036 -> this.META_SENDS_ESCAPE;
            case 1037 -> this.DEL_EDIT_KEYPAD_DEL;
            case 1039 -> this.ALT_SENDS_ESC;
            case 1040 -> this.KEEP_SELECTION;
            case 1041 -> this.USE_CLIP;
            case 1042 -> this.ENABLE_URGENCY;
            case 1043 -> this.RAISE_ON_CTRL_G;
            case 1044 -> this.KEEP_CLIP;
            case 1045 -> this.EXT_REV_WRAP;
            case 1046 -> this.ALLOW_ALT_BUFFER;
            case 1047 -> this.SWITCH_ALT_BUFFER;
            case 1048 -> this.SAVE_CURSOR;
            case 1049 -> this.SAVE_CLEAR_AND_SWITCH;
            case 1050 -> this.SET_TERMINFO_FUNC_KEY_MODE;
            case 1051 -> this.SET_SUN_KEY_MODE;
            case 1052 -> this.SET_HP_K0EY_MODE;
            case 1053 -> this.SET_SCO_KEY_MODE;
            case 1060 -> this.SET_LEGACY_KEYBOARD;
            case 1061 -> this.SET_VT220_KEYBOARD;
            case 2001 -> this.ENABLE_READLINE_MOUSE_1;
            case 2002 -> this.ENABLE_READLINE_MOUSE_2;
            case 2003 -> this.ENABLE_READLINE_MOUSE_3;
            case 2004 -> this.SET_BRACKETED_PASTE;
            case 2005 -> this.ENABLE_READLINE_CHAR_QUOTE;
            case 2006 -> this.ENABLE_READLINE_NEWLINE_PASTE;
            case 2026 -> this.APPLICATION_SYNC;
            case 7727 -> this.APPLICATION_ESC_MODE;
            default -> null;
        };
    }

    public MouseMode getMouseMode() {
        ArrayList<Integer> secondaryModes = new ArrayList<Integer>();
        int mode = this.X10MM ? 9 : (this.X11MM ? 1000 : (this.CELL_MOTION_MOUSE ? 1002 : (this.ALL_MOTION_MOUSE_TRACKING ? 1003 : 0)));
        if (this.UTF8_MOUSE) {
            secondaryModes.add(1005);
        }
        if (this.SGR_MOUSE) {
            secondaryModes.add(1006);
        }
        if (this.URXVT_MOUSE) {
            secondaryModes.add(1015);
        }
        if (this.SGR_MOUSE_PIXEL) {
            secondaryModes.add(1016);
        }
        return new MouseMode(mode, secondaryModes.stream().mapToInt(Integer::intValue).toArray());
    }

    public boolean isAltBufferEnabled() {
        return this.ALT_BUFFER || this.SWITCH_ALT_BUFFER || this.SAVE_CLEAR_AND_SWITCH;
    }
}

