/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.MultiBlockEnergizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.container.EnergizerPowerPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part.AbstractEnergizerPowerPortEntity;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPortHandler;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergizerPowerPortEntity
extends AbstractEnergizerPowerPortEntity
implements MenuProvider,
INeighborChangeListener {
    public EnergizerPowerPortEntity(EnergySystem system, BlockEntityType<?> entityType, BlockPos position, BlockState blockState) {
        super(entityType, position, blockState);
        this.setHandler(IPowerPortHandler.create((EnergySystem)system, (IoMode)IoMode.Passive, (AbstractMultiblockEntity)this));
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).build((AbstractModBlockEntity)this));
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int index;
        if (!this.isMachineAssembled()) {
            return 0;
        }
        int n = index = this.getIoDirection().isInput() ? 1 : 3;
        if (this.getPowerPortHandler().isConnected()) {
            ++index;
        }
        return index;
    }

    @Override
    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.setIoDirection(IoDirection.read((CompoundTag)data, (String)"iodir", (IoDirection)IoDirection.Input));
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        IoDirection.write((CompoundTag)data, (String)"iodir", (IoDirection)this.getIoDirection());
        return data;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        if (this.isConnected()) {
            this.getPowerPortHandler().checkConnections(this.m_58904_(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        if (this.isConnected()) {
            this.getPowerPortHandler().checkConnections(this.m_58904_(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new EnergizerPowerPortContainer(windowId, inventory, this);
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    public void onAttached(MultiBlockEnergizer newController) {
        super.onAttached((IMultiblockController)newController);
        this.getPowerPortHandler().checkConnections(this.m_58904_(), this.getWorldPosition());
    }

    public void onPostMachineAssembled(MultiBlockEnergizer controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.getPowerPortHandler().checkConnections(this.m_58904_(), this.getWorldPosition());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        LazyOptional cap = this.getPowerPortHandler().getCapability(capability, side);
        return null != cap ? cap : super.getCapability(capability, side);
    }
}

