/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.api.prefab.provider;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Optional;
import li.cil.manual.api.content.Document;
import li.cil.manual.api.provider.DocumentProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class NamespaceDocumentProvider
implements DocumentProvider {
    private final String namespace;
    private final String basePath;

    public NamespaceDocumentProvider(String namespace, String basePath) {
        this.namespace = namespace;
        this.basePath = basePath.endsWith("/") ? basePath : basePath + "/";
    }

    public NamespaceDocumentProvider(String namespace) {
        this(namespace, "");
    }

    @Override
    public Optional<Document> getDocument(String path, String language) {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        ResourceLocation location = new ResourceLocation(this.namespace, this.basePath + path);
        return resourceManager.m_213713_(location).flatMap(resource -> {
            Optional<Document> optional;
            block9: {
                InputStream stream = resource.m_215507_();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
                    ArrayList<String> lines = new ArrayList<String>();
                    while ((line = reader.readLine()) != null) {
                        lines.add(line);
                    }
                    optional = Optional.of(new Document(lines, location));
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ignored) {
                        return Optional.empty();
                    }
                }
                stream.close();
            }
            return optional;
        });
    }
}

