/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.multiplayer.fullData;

import com.seibel.distanthorizons.core.multiplayer.fullData.FullDataPayload;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSplitMessage;
import com.seibel.distanthorizons.core.network.session.NetworkSession;
import com.seibel.distanthorizons.core.util.TimerUtil;
import io.netty.buffer.ByteBuf;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;

public class FullDataPayloadSender
implements AutoCloseable {
    private static final int TICK_RATE = 20;
    public static final int FULL_DATA_SPLIT_SIZE_IN_BYTES = 1048000;
    private static final Timer UPLOAD_TIMER = TimerUtil.CreateTimer("FullDataPayloadSender");
    private final TimerTask tickTimerTask = TimerUtil.createTimerTask(this::tick);
    private final NetworkSession session;
    private final IntSupplier maxKBpsSupplier;
    private final ConcurrentLinkedQueue<PendingTransfer> transferQueue = new ConcurrentLinkedQueue();

    public FullDataPayloadSender(NetworkSession session, IntSupplier maxKBpsSupplier) {
        this.session = session;
        this.maxKBpsSupplier = maxKBpsSupplier;
        UPLOAD_TIMER.scheduleAtFixedRate(this.tickTimerTask, 0L, 50L);
    }

    @Override
    public void close() {
        PendingTransfer pendingTransfer;
        this.tickTimerTask.cancel();
        while ((pendingTransfer = this.transferQueue.poll()) != null) {
            pendingTransfer.close();
        }
    }

    public void sendInChunks(FullDataPayload payload, Runnable sendFinalMessage) {
        this.transferQueue.add(new PendingTransfer(payload, sendFinalMessage));
    }

    private void tick() {
        int chunkSize;
        int convertedMaxRate = this.maxKBpsSupplier.getAsInt();
        convertedMaxRate = convertedMaxRate > 0 ? convertedMaxRate : 2147483;
        for (int bytesToSend = convertedMaxRate * 1000 / 20 + 1; bytesToSend > 0; bytesToSend -= chunkSize) {
            PendingTransfer pendingTransfer = this.transferQueue.peek();
            if (pendingTransfer == null) {
                return;
            }
            chunkSize = Math.min(Math.min(bytesToSend, 1048000), pendingTransfer.buffer.readableBytes());
            boolean isFirstChunk = pendingTransfer.buffer.readerIndex() == 0;
            FullDataSplitMessage chunkMessage = new FullDataSplitMessage(pendingTransfer.bufferId, pendingTransfer.buffer.readRetainedSlice(chunkSize), isFirstChunk);
            this.session.sendMessage(chunkMessage);
            if (pendingTransfer.buffer.readableBytes() != 0) continue;
            pendingTransfer.sendFinalMessage.run();
            pendingTransfer.close();
            this.transferQueue.poll();
        }
    }

    private static class PendingTransfer
    implements AutoCloseable {
        public final int bufferId;
        public final ByteBuf buffer;
        public final Runnable sendFinalMessage;
        private final AtomicBoolean isClosed = new AtomicBoolean();

        private PendingTransfer(FullDataPayload payload, Runnable sendFinalMessage) {
            this.bufferId = payload.dtoBufferId;
            this.buffer = payload.dtoBuffer.retainedDuplicate().readerIndex(0);
            this.sendFinalMessage = sendFinalMessage;
        }

        @Override
        public void close() {
            if (this.isClosed.compareAndSet(false, true)) {
                this.buffer.release();
            }
        }
    }
}

