/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.fabric;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IPluginPacketSender;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.fabric.wrappers.modAccessor.SodiumAccessor;
import java.util.HashSet;
import loaderCommon.fabric.com.seibel.distanthorizons.common.AbstractModInitializer;
import loaderCommon.fabric.com.seibel.distanthorizons.common.AbstractPluginPacketSender;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_239;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_442;
import net.minecraft.class_638;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class FabricClientProxy
implements AbstractModInitializer.IEventProxy {
    private final ClientApi clientApi = ClientApi.INSTANCE;
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final AbstractPluginPacketSender PACKET_SENDER = (AbstractPluginPacketSender)SingletonInjector.INSTANCE.get(IPluginPacketSender.class);
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final int[] KEY_TO_CHECK_FOR = new int[]{295, 297, 80};
    HashSet<Integer> previouslyPressKeyCodes = new HashSet();

    @Override
    public void registerEvents() {
        LOGGER.info("Registering Fabric Client Events");
        SodiumAccessor sodiumAccessor = (SodiumAccessor)ModAccessorInjector.INSTANCE.get(ISodiumAccessor.class);
        ClientTickEvents.START_CLIENT_TICK.register(client -> ClientApi.INSTANCE.clientTickEvent());
        ClientChunkEvents.CHUNK_LOAD.register((level, chunk) -> {
            if (MC.clientConnectedToDedicatedServer()) {
                IClientLevelWrapper wrappedLevel = ClientLevelWrapper.getWrapper(level);
                SharedApi.INSTANCE.chunkLoadEvent(new ChunkWrapper((class_2791)chunk, wrappedLevel), wrappedLevel);
            }
        });
        AttackBlockCallback.EVENT.register((player, level, interactionHand, blockPos, direction) -> {
            PriorityTaskPicker.Executor executor;
            if (MC.clientConnectedToDedicatedServer() && SharedApi.isChunkAtBlockPosAlreadyUpdating(blockPos.method_10263(), blockPos.method_10260()) && (executor = ThreadPoolUtil.getFileHandlerExecutor()) != null) {
                executor.execute(() -> {
                    class_2791 chunk = level.method_22350(blockPos);
                    if (chunk != null) {
                        IClientLevelWrapper wrappedLevel = ClientLevelWrapper.getWrapper((class_638)level);
                        SharedApi.INSTANCE.chunkBlockChangedEvent(new ChunkWrapper(chunk, wrappedLevel), wrappedLevel);
                    }
                });
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, level, hand, hitResult) -> {
            PriorityTaskPicker.Executor executor;
            if (MC.clientConnectedToDedicatedServer() && hitResult.method_17783() == class_239.class_240.field_1332 && !hitResult.method_17781() && SharedApi.isChunkAtBlockPosAlreadyUpdating(hitResult.method_17777().method_10263(), hitResult.method_17777().method_10260()) && (executor = ThreadPoolUtil.getFileHandlerExecutor()) != null) {
                executor.execute(() -> {
                    class_2791 chunk = level.method_22350(hitResult.method_17777());
                    if (chunk != null) {
                        IClientLevelWrapper wrappedLevel = ClientLevelWrapper.getWrapper((class_638)level);
                        SharedApi.INSTANCE.chunkBlockChangedEvent(new ChunkWrapper(chunk, wrappedLevel), wrappedLevel);
                    }
                });
            }
            return class_1269.field_5811;
        });
        WorldRenderEvents.AFTER_SETUP.register(renderContext -> {
            Mat4f projectionMatrix = McObjectConverter.Convert(renderContext.projectionMatrix());
            Mat4f modelViewMatrix = McObjectConverter.Convert(renderContext.matrixStack().method_23760().method_23761());
            this.clientApi.renderLods(ClientLevelWrapper.getWrapper(renderContext.world()), modelViewMatrix, projectionMatrix, renderContext.tickDelta());
        });
        WorldRenderEvents.AFTER_ENTITIES.register(renderContext -> {
            Mat4f projectionMatrix = McObjectConverter.Convert(renderContext.projectionMatrix());
            Mat4f modelViewMatrix = McObjectConverter.Convert(renderContext.matrixStack().method_23760().method_23761());
            this.clientApi.renderFadeOpaque(modelViewMatrix, projectionMatrix, renderContext.tickDelta(), ClientLevelWrapper.getWrapper(renderContext.world()));
        });
        WorldRenderEvents.AFTER_TRANSLUCENT.register(renderContext -> {
            Mat4f projectionMatrix = McObjectConverter.Convert(renderContext.projectionMatrix());
            Mat4f modelViewMatrix = McObjectConverter.Convert(renderContext.matrixStack().method_23760().method_23761());
            this.clientApi.renderFade(modelViewMatrix, projectionMatrix, renderContext.tickDelta(), ClientLevelWrapper.getWrapper(renderContext.world()));
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null && !(class_310.method_1551().field_1755 instanceof class_442)) {
                this.onKeyInput();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AbstractPluginPacketSender.WRAPPER_PACKET_RESOURCE, (client, handler, buffer, packetSender) -> {
            AbstractNetworkMessage message = PACKET_SENDER.decodeMessage(buffer);
            if (message != null) {
                ClientApi.INSTANCE.pluginMessageReceived(message);
            }
        });
    }

    public void onKeyInput() {
        HashSet<Integer> currentKeyDown = new HashSet<Integer>();
        for (int keyCode = 65; keyCode <= 90; ++keyCode) {
            if (!class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)keyCode)) continue;
            currentKeyDown.add(keyCode);
        }
        for (int keyCode : KEY_TO_CHECK_FOR) {
            if (!class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)keyCode)) continue;
            currentKeyDown.add(keyCode);
        }
        Object object = currentKeyDown.iterator();
        while (object.hasNext()) {
            int keyCode = (Integer)object.next();
            if (this.previouslyPressKeyCodes.contains(keyCode)) continue;
            ClientApi.INSTANCE.keyPressedEvent(keyCode);
        }
        this.previouslyPressKeyCodes = currentKeyDown;
    }
}

