/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TintWithoutLevelOverrider
implements class_1920 {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final ConcurrentMap<String, class_6880<class_1959>> BIOME_BY_RESOURCE_STRING = new ConcurrentHashMap<String, class_6880<class_1959>>();
    @NotNull
    private final BiomeWrapper biomeWrapper;

    public TintWithoutLevelOverrider(@NotNull BiomeWrapper biomeWrapper, IClientLevelWrapper clientLevelWrapper) {
        this.biomeWrapper = biomeWrapper;
    }

    public int method_23752(@NotNull class_2338 blockPos, @NotNull class_6539 colorResolver) {
        String biomeString = this.biomeWrapper.getSerialString();
        if (biomeString == null || biomeString.isEmpty() || biomeString.equals("EMPTY")) {
            biomeString = "minecraft:plains";
        }
        return colorResolver.getColor(TintWithoutLevelOverrider.unwrap(TintWithoutLevelOverrider.getClientBiome(biomeString)), (double)blockPos.method_10263(), (double)blockPos.method_10260());
    }

    private static class_1959 unwrap(class_6880<class_1959> biome) {
        return (class_1959)biome.comp_349();
    }

    private static class_6880<class_1959> getClientBiome(String biomeResourceString) {
        return BIOME_BY_RESOURCE_STRING.compute(biomeResourceString, (resourceString, existingBiome) -> {
            BiomeWrapper.BiomeDeserializeResult result;
            if (existingBiome != null) {
                return existingBiome;
            }
            class_638 clientLevel = class_310.method_1551().field_1687;
            if (clientLevel == null) {
                throw new IllegalStateException("Attempted to get client biome when no client level was loaded.");
            }
            try {
                result = BiomeWrapper.deserializeBiome(resourceString, clientLevel.method_30349());
            }
            catch (Exception e) {
                LOGGER.warn("Unable to deserialize client biome [" + resourceString + "], using fallback...");
                try {
                    result = BiomeWrapper.deserializeBiome("minecraft:plains", clientLevel.method_30349());
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to deserialize fallback client biome [minecraft:plains], returning NULL.");
                    return null;
                }
            }
            if (result.success) {
                existingBiome = result.biome;
            }
            return existingBiome;
        });
    }

    public float method_24852(@NotNull class_2350 direction, boolean shade) {
        throw new UnsupportedOperationException("ERROR: getShade() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @NotNull
    public class_3568 method_22336() {
        throw new UnsupportedOperationException("ERROR: getLightEngine() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @Nullable
    public class_2586 method_8321(@NotNull class_2338 pos) {
        throw new UnsupportedOperationException("ERROR: getBlockEntity() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @NotNull
    public class_2680 method_8320(@NotNull class_2338 pos) {
        throw new UnsupportedOperationException("ERROR: getBlockState() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @NotNull
    public class_3610 method_8316(@NotNull class_2338 pos) {
        throw new UnsupportedOperationException("ERROR: getFluidState() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    public int method_31605() {
        throw new UnsupportedOperationException("ERROR: getHeight() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    public int method_31607() {
        throw new UnsupportedOperationException("ERROR: getMinBuildHeight() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }
}

